/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.bean;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import org.eclipse.sisu.inject.Logs;

final class BeanLifecycle
implements PrivilegedAction<Void> {
    private static final Method[] NO_METHODS = new Method[0];
    static final BeanLifecycle NO_OP = new BeanLifecycle(null, null);
    private final Method[] startMethods;
    private final Method[] stopMethods;

    BeanLifecycle(List<Method> startMethods, List<Method> stopMethods) {
        this.startMethods = BeanLifecycle.toArray(startMethods);
        this.stopMethods = BeanLifecycle.toArray(stopMethods);
        AccessController.doPrivileged(this);
    }

    public boolean isStartable() {
        return this.startMethods.length > 0;
    }

    public boolean isStoppable() {
        return this.stopMethods.length > 0;
    }

    public void start(Object bean2) {
        Logs.trace("PostConstruct: <>", bean2, null);
        int i = this.startMethods.length - 1;
        try {
            while (i >= 0) {
                this.startMethods[i].invoke(bean2, new Object[0]);
                --i;
            }
        }
        catch (Throwable e2) {
            Throwable cause = e2 instanceof InvocationTargetException ? e2.getCause() : e2;
            Logs.catchThrowable(cause);
            try {
                Logs.warn("Error starting: {}", this.startMethods[i], cause);
            }
            finally {
                Logs.throwUnchecked(cause);
            }
        }
    }

    public void stop(Object bean2) {
        Logs.trace("PreDestroy: <>", bean2, null);
        int i = 0;
        while (i < this.stopMethods.length) {
            try {
                this.stopMethods[i].invoke(bean2, new Object[0]);
            }
            catch (Throwable e2) {
                Throwable cause = e2 instanceof InvocationTargetException ? e2.getCause() : e2;
                Logs.catchThrowable(cause);
                try {
                    Logs.warn("Problem stopping: {}", this.stopMethods[i], cause);
                }
                catch (Throwable throwable) {}
            }
            ++i;
        }
    }

    @Override
    public Void run() {
        AccessibleObject.setAccessible(this.startMethods, true);
        AccessibleObject.setAccessible(this.stopMethods, true);
        return null;
    }

    private static Method[] toArray(List<Method> methods2) {
        return methods2 != null && !methods2.isEmpty() ? methods2.toArray(new Method[methods2.size()]) : NO_METHODS;
    }
}

