/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.transform;

import java.util.IllegalFormatException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.transform.TransformationException;
import org.openhab.core.transform.TransformationService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@NonNullByDefault
public class TransformationHelper {
    private static final Map<String, TransformationService> SERVICES = new ConcurrentHashMap<String, TransformationService>();
    private static final Logger LOGGER = LoggerFactory.getLogger(TransformationHelper.class);
    public static final String FUNCTION_VALUE_DELIMITER = ":";
    protected static final Pattern EXTRACT_TRANSFORMFUNCTION_PATTERN = Pattern.compile("(.*?)\\((.*)\\):(.*)");
    private final BundleContext bundleContext;

    @Activate
    public TransformationHelper(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Deactivate
    public void deactivate() {
        SERVICES.clear();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void setTransformationService(ServiceReference<TransformationService> ref) {
        String key = (String)ref.getProperty("openhab.transform");
        TransformationService service = (TransformationService)this.bundleContext.getService(ref);
        if (service != null) {
            SERVICES.put(key, service);
            LOGGER.debug("Added transformation service {}", (Object)key);
        }
    }

    public void unsetTransformationService(ServiceReference<TransformationService> ref) {
        String key = (String)ref.getProperty("openhab.transform");
        if (SERVICES.remove(key) != null) {
            LOGGER.debug("Removed transformation service {}", (Object)key);
        }
    }

    public static boolean isTransform(String pattern) {
        return EXTRACT_TRANSFORMFUNCTION_PATTERN.matcher(pattern).matches();
    }

    public static @Nullable TransformationService getTransformationService(String serviceName) {
        return SERVICES.get(serviceName);
    }

    @Deprecated
    public static @Nullable TransformationService getTransformationService(@Nullable BundleContext context, String transformationType) {
        return TransformationHelper.getTransformationService(transformationType);
    }

    @Deprecated
    public static @Nullable String transform(BundleContext context, String transformationString, String state) throws TransformationException {
        return TransformationHelper.transform(transformationString, state);
    }

    public static @Nullable String transform(String transformationString, String state) throws TransformationException {
        Matcher matcher = EXTRACT_TRANSFORMFUNCTION_PATTERN.matcher(transformationString);
        if (matcher.find()) {
            String type = matcher.group(1);
            String pattern = matcher.group(2);
            String value = matcher.group(3);
            TransformationService transformation = SERVICES.get(type);
            if (transformation != null) {
                return TransformationHelper.transform(transformation, pattern, value, state);
            }
            throw new TransformationException("Couldn't transform value because transformation service of type '" + type + "' is not available.");
        }
        return state;
    }

    public static @Nullable String transform(TransformationService service, String function, String format, String state) throws TransformationException {
        try {
            String value = String.format(format, state);
            return service.transform(function, value);
        }
        catch (IllegalFormatException e) {
            throw new TransformationException("Cannot format state '" + state + "' to format '" + format + "'", e);
        }
        catch (RuntimeException e) {
            throw new TransformationException("Transformation service threw an exception: " + e.getMessage(), e);
        }
    }
}

