/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_rect")
public class NkRect
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;
    public static final int W;
    public static final int H;

    public NkRect(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NkRect.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public float x() {
        return NkRect.nx(this.address());
    }

    public float y() {
        return NkRect.ny(this.address());
    }

    public float w() {
        return NkRect.nw(this.address());
    }

    public float h() {
        return NkRect.nh(this.address());
    }

    public NkRect x(float value) {
        NkRect.nx(this.address(), value);
        return this;
    }

    public NkRect y(float value) {
        NkRect.ny(this.address(), value);
        return this;
    }

    public NkRect w(float value) {
        NkRect.nw(this.address(), value);
        return this;
    }

    public NkRect h(float value) {
        NkRect.nh(this.address(), value);
        return this;
    }

    public NkRect set(float x, float y, float w, float h) {
        this.x(x);
        this.y(y);
        this.w(w);
        this.h(h);
        return this;
    }

    public NkRect set(NkRect src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static NkRect malloc() {
        return (NkRect)NkRect.wrap(NkRect.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static NkRect calloc() {
        return (NkRect)NkRect.wrap(NkRect.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static NkRect create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (NkRect)NkRect.wrap(NkRect.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static NkRect create(long address) {
        return (NkRect)NkRect.wrap(NkRect.class, (long)address);
    }

    @Nullable
    public static NkRect createSafe(long address) {
        return address == 0L ? null : (NkRect)NkRect.wrap(NkRect.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)NkRect.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)NkRect.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)NkRect.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkRect.__create((int)capacity, (int)SIZEOF);
        return (Buffer)NkRect.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)NkRect.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)NkRect.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static NkRect mallocStack() {
        return NkRect.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkRect callocStack() {
        return NkRect.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkRect mallocStack(MemoryStack stack) {
        return NkRect.malloc(stack);
    }

    @Deprecated
    public static NkRect callocStack(MemoryStack stack) {
        return NkRect.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return NkRect.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return NkRect.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkRect.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkRect.calloc(capacity, stack);
    }

    public static NkRect malloc(MemoryStack stack) {
        return (NkRect)NkRect.wrap(NkRect.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkRect calloc(MemoryStack stack) {
        return (NkRect)NkRect.wrap(NkRect.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)NkRect.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)NkRect.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static float nx(long struct) {
        return UNSAFE.getFloat(null, struct + (long)X);
    }

    public static float ny(long struct) {
        return UNSAFE.getFloat(null, struct + (long)Y);
    }

    public static float nw(long struct) {
        return UNSAFE.getFloat(null, struct + (long)W);
    }

    public static float nh(long struct) {
        return UNSAFE.getFloat(null, struct + (long)H);
    }

    public static void nx(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)X, value);
    }

    public static void ny(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)Y, value);
    }

    public static void nw(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)W, value);
    }

    public static void nh(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)H, value);
    }

    static {
        Struct.Layout layout = NkRect.__struct((Struct.Member[])new Struct.Member[]{NkRect.__member((int)4), NkRect.__member((int)4), NkRect.__member((int)4), NkRect.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
        W = layout.offsetof(2);
        H = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<NkRect, Buffer>
    implements NativeResource {
        private static final NkRect ELEMENT_FACTORY = NkRect.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected NkRect getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float x() {
            return NkRect.nx(this.address());
        }

        public float y() {
            return NkRect.ny(this.address());
        }

        public float w() {
            return NkRect.nw(this.address());
        }

        public float h() {
            return NkRect.nh(this.address());
        }

        public Buffer x(float value) {
            NkRect.nx(this.address(), value);
            return this;
        }

        public Buffer y(float value) {
            NkRect.ny(this.address(), value);
            return this;
        }

        public Buffer w(float value) {
            NkRect.nw(this.address(), value);
            return this;
        }

        public Buffer h(float value) {
            NkRect.nh(this.address(), value);
            return this;
        }
    }
}

