/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.updater.liquibase.custom;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import liquibase.exception.CustomChangeException;
import liquibase.statement.core.DeleteStatement;
import liquibase.structure.core.Column;
import org.keycloak.connections.jpa.updater.liquibase.custom.CustomKeycloakTask;

public class RemoveDuplicateOfflineSessions
extends CustomKeycloakTask {
    @Override
    protected void generateStatementsImpl() throws CustomChangeException {
        HashSet<String> clientSessionIdsToDelete = new HashSet<String>();
        String tableName = this.getTableName("OFFLINE_CLIENT_SESSION");
        String colClientSessionId = this.database.correctObjectName("CLIENT_SESSION_ID", Column.class);
        try (PreparedStatement ps = this.connection.prepareStatement(String.format("SELECT t.CLIENT_SESSION_ID, t.USER_SESSION_ID, t.CLIENT_ID, t.OFFLINE_FLAG  FROM %1$s t,    (SELECT USER_SESSION_ID, CLIENT_ID, OFFLINE_FLAG      FROM %1$s    GROUP BY USER_SESSION_ID, CLIENT_ID, OFFLINE_FLAG    HAVING COUNT(*) > 1) t1  WHERE t.USER_SESSION_ID = t1.USER_SESSION_ID    AND t.CLIENT_ID = t1.CLIENT_ID    AND t.OFFLINE_FLAG = t1.OFFLINE_FLAG  ORDER BY t.USER_SESSION_ID, t.CLIENT_ID, t.OFFLINE_FLAG", tableName));
             ResultSet resultSet = ps.executeQuery();){
            Key origKey = new Key(null, null, null);
            while (resultSet.next()) {
                String clientSessionId = resultSet.getString(1);
                Key key = new Key(resultSet.getString(2), resultSet.getString(3), resultSet.getString(4));
                if (key.equals(origKey)) {
                    clientSessionIdsToDelete.add(clientSessionId);
                    continue;
                }
                origKey = key;
            }
        }
        catch (Exception e) {
            throw new CustomChangeException(this.getTaskId() + ": Exception when updating data from previous version", (Throwable)e);
        }
        AtomicInteger ai = new AtomicInteger();
        clientSessionIdsToDelete.stream().collect(Collectors.groupingByConcurrent(id -> ai.getAndIncrement() / 20, Collectors.toList())).values().stream().map(ids -> new DeleteStatement(null, null, "OFFLINE_CLIENT_SESSION").setWhere(":name IN (" + ids.stream().map(id -> "?").collect(Collectors.joining(",")) + ")").addWhereColumnName(colClientSessionId).addWhereParameters(ids.toArray())).forEach(this.statements::add);
    }

    @Override
    protected String getTaskId() {
        return "Leave only single offline session per user and client";
    }

    private static class Key {
        private final String userSessionId;
        private final String clientId;
        private final String offlineFlag;

        public Key(String userSessionId, String clientId, String offlineFlag) {
            this.userSessionId = userSessionId;
            this.clientId = clientId;
            this.offlineFlag = offlineFlag;
        }

        public int hashCode() {
            int hash = 7;
            hash = 73 * hash + Objects.hashCode(this.userSessionId);
            hash = 73 * hash + Objects.hashCode(this.clientId);
            hash = 73 * hash + Objects.hashCode(this.offlineFlag);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            return Objects.equals(this.userSessionId, other.userSessionId) && Objects.equals(this.clientId, other.clientId) && Objects.equals(this.offlineFlag, other.offlineFlag);
        }
    }
}

