/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.SessionEventListener;
import org.hibernate.engine.internal.StatisticalLoggingSessionEventListener;

@Deprecated(since="7.0", forRemoval=true)
public class BaselineSessionEventsListenerBuilder {
    private static final SessionEventListener[] EMPTY = new SessionEventListener[0];
    private final Class<? extends SessionEventListener> autoListener;

    public BaselineSessionEventsListenerBuilder(Class<? extends SessionEventListener> autoListener) {
        this.autoListener = autoListener;
    }

    public Class<? extends SessionEventListener> getAutoListener() {
        return this.autoListener;
    }

    public List<SessionEventListener> buildBaselineList() {
        SessionEventListener[] sessionEventListeners = this.buildBaseline();
        ArrayList<SessionEventListener> list = new ArrayList<SessionEventListener>(sessionEventListeners.length + 3);
        Collections.addAll(list, sessionEventListeners);
        return list;
    }

    public SessionEventListener[] buildBaseline() {
        SessionEventListener[] sessionEventListenerArray;
        if (StatisticalLoggingSessionEventListener.isLoggingEnabled()) {
            SessionEventListener[] sessionEventListenerArray2;
            if (this.autoListener == null) {
                SessionEventListener[] sessionEventListenerArray3 = new SessionEventListener[1];
                sessionEventListenerArray2 = sessionEventListenerArray3;
                sessionEventListenerArray3[0] = BaselineSessionEventsListenerBuilder.statsListener();
            } else {
                SessionEventListener[] sessionEventListenerArray4 = new SessionEventListener[2];
                sessionEventListenerArray4[0] = BaselineSessionEventsListenerBuilder.statsListener();
                sessionEventListenerArray2 = sessionEventListenerArray4;
                sessionEventListenerArray4[1] = this.autoListener();
            }
            return sessionEventListenerArray2;
        }
        if (this.autoListener == null) {
            sessionEventListenerArray = EMPTY;
        } else {
            SessionEventListener[] sessionEventListenerArray5 = new SessionEventListener[1];
            sessionEventListenerArray = sessionEventListenerArray5;
            sessionEventListenerArray5[0] = this.autoListener();
        }
        return sessionEventListenerArray;
    }

    private SessionEventListener autoListener() {
        try {
            return this.autoListener.newInstance();
        }
        catch (Exception e) {
            throw new HibernateException("Unable to instantiate specified auto SessionEventListener: " + this.autoListener.getName(), e);
        }
    }

    private static SessionEventListener statsListener() {
        return new StatisticalLoggingSessionEventListener();
    }
}

