/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.objectstore.slot;

import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.internal.arjuna.objectstore.slot.BackingSlots;
import com.arjuna.ats.internal.arjuna.objectstore.slot.SlotStoreEnvironmentBean;
import io.mashona.logwriting.ArrayStore;
import io.mashona.logwriting.PmemUtil;
import java.io.File;
import java.io.IOException;

public class PmemSlots
implements BackingSlots {
    private SlotStoreEnvironmentBean config;
    private ArrayStore arrayStore;

    @Override
    public void init(SlotStoreEnvironmentBean config) throws IOException {
        if (this.config != null) {
            throw new IllegalStateException(tsLogger.i18NLogger.get_pmemslots_already_initialized());
        }
        this.config = config;
        File storeDir = new File(config.getStoreDir());
        if (!storeDir.exists() && !storeDir.mkdirs()) {
            throw new IOException(tsLogger.i18NLogger.get_dir_create_failed(storeDir.getCanonicalPath()));
        }
        if (!PmemUtil.isPmemSupportedFor((File)storeDir)) {
            throw new IOException(tsLogger.i18NLogger.get_pmem_not_supported(config.getStoreDir()));
        }
        File storeFile = new File(storeDir, "slotstore.pmem");
        this.arrayStore = PmemUtil.arrayStoreFor((File)storeFile, (int)config.getNumberOfSlots(), (int)config.getBytesPerSlot());
    }

    @Override
    public void write(int slot, byte[] data, boolean sync) throws IOException {
        this.arrayStore.write(slot, data, sync);
    }

    @Override
    public byte[] read(int slot) throws IOException {
        return this.arrayStore.readAsByteArray(slot);
    }

    @Override
    public void clear(int slot, boolean sync) throws IOException {
        this.arrayStore.clear(slot, sync);
    }
}

