/**
*
* Jquery Mapael - Dynamic maps jQuery plugin (based on raphael.js)
* Requires jQuery and raphael.js
*
* Map of Auvergne for Mapael
* Equirectangular projection
* 
* @author CCM Benchmark Group
* @source http://fr.m.wikipedia.org/wiki/Fichier:France_location_map-Departements.svg
*/
(function($) {
	$.extend(true, $.fn.mapael, 
		{
			maps :  {
				france_region_83 : {
					width : 110.71876,
					height : 144.4375,
					getCoords : function (lat, lon) {
						var xfactor = 45.48385;
						var xoffset = -94.0269;
						var x = (lon * xfactor) + xoffset;
						
						var yfactor = -65.97284;
						var yoffset = 3087.5024;
						var y = (lat * yfactor) + yoffset;
						return {x : x, y : y};
					},
					elems : {
					    "department-15" : "m 20.54,87.49 c -0.8,0.47 -0.55,1.75 -0.9,2.51 -0.23,0.79 -0.46,1.95 0.55,2.33 0.68,0.2 1.19,1.37 0.36,1.68 -0.68,0.1 -1.38,0.38 -1.84,0.85 -0.22,-0.59 -0.71,-0.98 -1.37,-0.9 -0.65,-0.21 -1.06,-0.93 -1.8,-0.93 -0.75,-0.43 -1.44,-1.39 -2.42,-0.99 -0.15,0.71 0.76,1.28 0.5,2.06 0.08,1.04 -0.51,1.95 -0.36,2.97 -0.23,1 -1.53,0.46 -1.97,1.28 -0.63,0.7 -0.79,2.09 -1.96,2.04 -0.61,0.2 -0.43,1.06 -1.07,1.28 -0.46,0.53 -0.4,1.28 -1.04,1.71 -0.68,0.7 -2.08,1.8 -1.19,2.84 -0.03,0.84 0.59,1.39 1.24,1.81 0.49,0.35 0.07,0.63 -0.34,0.68 -0.49,0.53 -0.58,1.38 -1.33,1.7 -0.57,0.44 0.16,1.17 -0.34,1.67 -0.24,0.61 -0.04,1.39 -0.55,1.91 -0.78,-0.52 -1.73,-0.13 -2.35,0.49 -1.01,0.52 -1.2,1.33 -0.47,2.2 0.21,0.93 0.8,1.65 1.52,2.27 -0.18,0.73 -0.43,1.67 -1.39,1.53 -0.66,-0.01 -2,-0.23 -2,0.76 C 0.51,121.97 0.4,122.86 0.64,123.66 c 0.3,0.55 1.52,1.14 0.86,1.83 -1.08,0.51 -0.57,1.84 0,2.54 0.89,1.19 1.4,2.75 2.77,3.51 0.31,0.45 0.16,1.1 0.4,1.6 0.04,0.64 -0.31,1.19 -0.75,1.58 -0.26,1.34 0.1,2.82 -0.89,3.92 -0.44,0.46 0.18,1.23 0.6,0.63 0.65,-0.21 0.94,0.84 1.23,1.25 0.32,0.6 -0.37,1.16 -0.17,1.83 -0.08,0.98 0.87,1.77 1.67,2.09 0.71,-0.46 -0.43,-1.47 0.36,-1.96 0.55,-0.64 1.48,-0.04 2.06,-0.63 0.97,-0.35 2.18,-0.72 3.19,-0.52 0.33,0.53 0.14,1.54 1.03,1.58 0.7,0.06 1.26,-0.63 2,-0.29 0.8,0.04 1.74,0.7 2.4,-0.06 0.63,0.11 1.57,-0.18 1.68,-0.94 0.13,-1.84 2.06,-2.71 2.86,-4.17 0.05,-1.23 0.24,-2.48 0.79,-3.58 0.42,-0.53 1.52,-0.41 1.41,-1.32 -0.06,-0.78 0.04,-1.52 0.48,-2.16 -0.04,-0.41 -0.34,-0.8 0.15,-1.11 0.51,-0.56 0.58,-1.91 1.65,-1.49 0.72,-0.1 0.28,-1.1 0.85,-1.45 0.34,-0.65 0.91,-0.94 1.61,-0.93 0.57,-0.42 0.4,-1.41 1.16,-1.62 0.17,-0.27 0.58,-0.77 0.76,-0.27 1.47,0.42 1.53,2.3 1.48,3.57 -0.14,0.75 -0.39,2.33 0.6,1.06 0.73,-1.02 2.09,0 3.04,-0.58 0.65,0.13 -0.05,1.09 0.28,1.52 0.45,1.38 0.62,3.08 1.62,4.24 0.56,0.41 0.9,-0.91 1.34,-0.23 0.5,0.54 0.78,1.43 0.09,1.96 -0.11,0.47 0.47,0.83 0.26,1.37 -0.15,0.53 -0.4,1.04 -0.15,1.64 0.37,1.19 0.49,2.48 1.31,3.48 0.23,0.37 0.48,1.44 1.06,0.8 0.65,-1.26 0.93,-2.71 1.58,-3.95 0.41,-0.21 1.34,-0.62 0.63,-1.1 -0.45,-1.29 0.9,-2.28 0.73,-3.59 -0.09,-1.08 0.3,-2.31 1.27,-2.84 0.13,-0.34 -0.31,-0.95 0.35,-0.67 1.02,0.18 0.53,-1.07 0.74,-1.61 0.55,-0.61 -0.09,-1.77 0.84,-2.13 0.33,-0.36 0.53,-1.12 1.19,-0.76 0.91,0.61 0.94,2.25 2.15,2.42 0.26,-0.4 0.65,-0.55 1.11,-0.64 1.05,-0.31 0.61,-1.47 0.63,-2.24 0.53,-0.24 1.01,-0.69 0.88,-1.35 -0.13,-0.45 0.63,-1.12 0.89,-0.63 -0.07,0.88 1.08,0.82 1.44,0.22 0.86,-0.41 1.54,-1.27 2.52,-1.38 0.71,-0.64 -1.13,-1.9 0.29,-2.11 0.64,-0.29 0.29,-0.97 -0.28,-0.94 -0.16,-0.45 -0.76,-0.43 -1.06,-0.53 0.29,-0.55 -0.22,-0.96 -0.73,-0.7 -0.67,-0.04 -0.58,-1.1 -0.62,-1.59 -0.16,-0.89 0.65,-1.74 0.31,-2.57 -0.41,-0.15 -0.94,-0.21 -0.99,-0.78 -0.26,-0.69 0.9,-0.7 1.22,-0.31 0.61,0.54 1.49,0.28 1.98,-0.27 -0.39,-0.34 -1.23,-0.16 -1.68,-0.66 -0.38,-0.38 -0.95,-0.37 -1.39,-0.4 -0.5,-0.67 -0.36,-1.65 -0.94,-2.25 -0.37,-1.17 0.22,-2.46 -0.14,-3.59 -0.5,-0.42 -1.6,-0.39 -1.37,-1.33 0,-0.66 -0.76,-1.02 -0.43,-1.73 0.44,-1.02 -0.85,-1.8 -1.68,-1.31 -0.39,0.23 -1.26,0.51 -1.05,-0.29 -0.08,-0.92 -1.3,-0.26 -1.84,-0.3 -0.62,0.05 -1.3,-0.23 -1.8,-0.47 0.03,-0.67 1.21,-0.55 1.1,-1.18 -0.13,-0.35 -1.09,-0.81 -0.6,-1.17 0.87,0.12 0.9,-1.17 0.45,-1.61 -0.63,-0.11 -0.52,0.98 -1.2,1 -0.57,0.11 -0.75,0.65 -0.58,1.15 -0.16,1.14 -1.56,1.37 -2.18,2.11 -1.18,-0.06 -1.99,-1.07 -3.06,-1.45 -1.06,-0.93 -1.25,-2.39 -1.6,-3.66 -0.67,-0.36 -1.34,-1.28 -2.13,-0.66 -0.55,-0.57 -1.17,-1.16 -2.01,-1.13 -0.36,-0.29 -0.79,-0.56 -1.22,-0.13 -0.41,0.34 -0.74,0.73 -1.34,0.48 -0.77,-0.05 -1.74,-0.56 -2.31,0.22 -0.84,0.11 -0.99,-1.16 -1.61,-1.52 -0.54,-0.59 0.06,-1.36 0.03,-1.96 -0.53,-0.21 -1.24,0.25 -1.68,-0.33 -0.27,-0.28 -0.72,-0.17 -0.99,-0.21 -0.09,-0.45 -0.4,-1.36 -0.93,-0.71 -0.65,0.57 -1.42,0 -1.91,-0.46 -0.43,-0.29 -1.12,0.55 -1.39,0.11 0.09,-0.46 0.48,-1.26 -0.3,-1.32 -0.16,-0.03 -0.32,-0.08 -0.49,-0.05 z",
					    "department-63" : "m 36.07,36.38 c -0.9,0.17 -1.93,0.8 -1.63,1.88 -0.04,0.64 -0.03,1.64 -0.67,1.93 -0.87,-0.07 -1.43,-0.79 -2.22,-1.03 -0.34,-0.27 -1.24,-1.11 -1.38,-0.25 -0.22,0.71 0.33,2.04 -0.57,2.36 -0.82,-0.05 -1.83,0.3 -1.86,1.24 -0.49,0.88 -0.51,2.67 -1.83,2.71 -0.68,-0.25 -1.34,-0.6 -2.06,-0.62 -0.52,-0.14 -1.26,-1.29 -1.43,-0.28 -0.75,2.24 -0.21,5.13 1.87,6.46 0.55,1.12 -0.72,2.5 0.2,3.58 0.42,0.44 0.29,1.08 -0.34,1.16 -0.64,0.15 -1.25,0.5 -1.41,1.16 -0.74,0.36 -1.47,1.64 -0.51,2.17 -0.92,1 -2.18,1.76 -2.75,3.07 -0.43,0.55 -0.88,-0.38 -1.42,-0.08 -0.73,-0.07 -0.93,0.62 -0.72,1.19 -0.27,0.73 -1.2,1.2 -1.97,0.99 -0.95,0.11 -0.35,1.23 0.08,1.59 0.71,0.78 1.26,1.68 1.41,2.72 0.75,0.68 1.75,1.04 2.37,1.88 0.92,1.13 2.18,2.68 1.52,4.2 -0.5,0.53 -0.03,1.09 0.12,1.61 -0.05,0.65 -0.53,1.13 -1.22,0.93 -1.22,0.13 -0.47,1.7 -1.15,2.33 -0.81,0.72 0.26,1.64 0.64,2.28 0.3,0.56 0.86,0.86 1.3,1.2 0.32,1.19 -0.12,2.39 -0.19,3.56 0.19,0.33 -0.03,0.88 0.53,0.96 0.54,0.06 1.08,0.26 0.82,0.92 0.08,0.9 1.24,-0.1 1.53,0.68 0.39,0.43 1.2,0.75 1.49,0.04 0.18,-0.43 0.8,-0.56 0.81,0.02 -0.03,0.62 0.49,0.89 1.01,0.91 0.45,0.59 1.19,0.32 1.8,0.38 0.43,0.52 -0.55,1.33 -0.05,1.93 0.45,0.46 0.73,1.2 1.27,1.51 0.66,-0.09 1.29,-0.72 1.94,-0.22 1,0.46 1.88,-0.49 2.76,-0.64 0.52,0.67 1.75,0.04 2.01,1.04 0.19,0.5 0.66,0.35 0.97,0.1 0.68,0.07 1.06,0.89 1.74,0.99 0.5,1.27 0.5,3.04 1.78,3.86 1.01,0.13 1.76,1.47 2.82,1.2 0.36,-0.8 1.81,-0.67 1.89,-1.76 -0.09,-0.71 0.31,-1.41 1.02,-1.51 0.55,-0.36 0.6,-1.29 1.44,-0.93 0.89,-0.13 2.12,0.47 2.84,-0.21 0.09,-0.52 0.72,-0.45 0.99,-0.84 0.48,-0.08 1.03,-0.16 1.07,-0.76 0.22,-0.6 0.77,-0.87 1.37,-0.68 1.07,0.03 1.77,-0.88 2.12,-1.77 0.69,-0.51 1.05,1.29 1.62,0.84 -0.08,-0.56 0.46,-1.5 1.07,-0.97 0.55,0.59 0.99,1.39 1.94,1.15 1.05,-0.15 2.6,0.69 3.14,-0.58 0.37,-0.44 1.02,-1.18 1.63,-0.9 0.08,1.24 1.62,2.04 2.72,1.75 0.49,-0.47 0.61,0.71 0.83,0.98 0.29,1.12 0.69,2.25 1.69,2.94 0.62,0.36 0.9,-0.92 1.43,-1.22 0.58,-0.36 0.63,-1.51 1.36,-1.54 0.58,0.21 1.15,0.67 1.18,1.27 0.73,0.19 1.49,0.22 2.22,0.49 1.08,0.45 1.66,-0.06 1.54,-1.17 0.02,-0.73 0.96,-1.74 1.55,-0.84 0.32,0.23 0.83,0.07 0.79,0.61 0.48,0.72 1.45,1.53 2.35,1.31 0.49,-1.22 -0.43,-2.88 0.75,-3.87 0.66,-0.68 1.55,-1.15 2.45,-1.39 0.15,-0.28 -0.09,-0.59 0.31,-0.72 0.35,-0.78 -0.28,-1.84 0.59,-2.41 0.6,-0.8 -0.69,-1.05 -0.83,-1.74 -0.51,-0.94 -0.58,-2 -0.6,-3.03 -0.47,-1.47 -1.59,-2.72 -3.05,-3.22 -0.65,-0.25 -0.85,-0.93 -1.36,-1.28 -0.76,-0.16 -1.53,-0.51 -1.59,-1.4 -0.33,-0.58 -0.83,-1.01 -0.99,-1.67 -0.65,-0.88 -1.01,-1.92 -0.83,-3.02 0.05,-0.69 -0.67,-1 -0.92,-1.6 -0.35,-0.21 -0.82,-0.14 -1.02,-0.63 -0.43,-0.33 -0.31,-0.69 -0.11,-1.07 -0.03,-1.02 -1.88,-0.88 -1.71,-1.93 0.79,-0.61 1.44,-1.71 1.27,-2.74 -0.11,-0.73 -0.3,-1.64 -0.21,-2.31 1.01,0.04 1.78,-1.19 1.1,-2.04 -0.49,-0.79 -1.15,-1.51 -2.04,-1.81 -0.63,-0.4 -0.82,-1.1 -1.07,-1.72 -0.51,-0.69 -1.54,-0.26 -2.1,-0.73 -0.22,-1.31 -0.82,-2.67 -1.72,-3.64 -0.54,-0.1 -1.02,0.5 -1.62,0.36 -0.58,0.22 -1.2,-0.61 -1.65,-0.01 -0.82,0.24 -1.7,0.24 -2.55,0.36 -0.16,-1.02 0.35,-2.45 -0.53,-3.22 -0.52,-0.14 -1.11,-0.11 -1.4,-0.67 -1.39,-0.19 -2.43,1.26 -3.76,1.5 -0.64,0.34 -0.37,-0.83 -1.07,-0.8 -1.34,-0.6 -2.95,0 -4.25,-0.61 -0.38,-0.23 -0.91,-0.62 -1.46,-0.38 -0.43,0.23 -0.75,0.61 -1.32,0.45 -0.86,0.02 -1.62,-0.32 -2.26,-0.84 -0.93,0.04 -0.64,-1.09 -0.86,-1.66 -0.67,-0.77 -1.62,0.57 -2.42,0.11 -0.59,-0.04 -1.39,0.11 -1.54,-0.67 -0.34,-0.71 -1.13,-0.62 -1.75,-0.66 -0.82,-0.78 -0.42,-2.23 -1.05,-3.05 -0.44,-0.2 -1.62,-0.12 -1.61,-0.77 0.75,-0.57 -0.48,-1.69 0.33,-2.32 0.48,-0.19 0.82,-0.59 0.63,-1.13 0.32,-0.41 0.14,-0.99 -0.45,-1.03 -1,-0.13 -2.04,-0.13 -3.01,-0.33 z",
					    "department-43" : "m 65.15,91.27 c -0.94,0.35 -1.29,1.86 -2.53,1.58 -1.2,0 -2.77,0.21 -3.47,-1.01 -0.39,-0.64 -1.13,-0.17 -1.15,0.45 -0.05,0.3 -0.32,1.06 -0.58,0.43 -0.16,-0.42 -0.81,-1.54 -1.27,-0.77 -0.25,1.3 -1.7,1.6 -2.81,1.66 -0.71,0.12 -0.4,1.59 -1.2,1.31 -0.71,-0.07 -1.14,0.68 -1.45,1.14 -0.95,0.16 -1.95,-0.15 -2.88,0.03 -0.03,0.66 0.33,1.7 -0.68,1.81 -0.25,0.42 1.01,0.58 0.54,1.18 -0.23,0.26 -1.01,0.49 -0.44,0.87 0.82,0.6 1.92,0.23 2.65,-0.19 0.47,0.33 0.23,1.13 0.68,1.36 0.52,-0.44 1.29,-0.69 1.91,-0.21 1.07,0.46 0.13,1.75 0.75,2.5 0.26,0.57 0.06,1.59 1.01,1.62 0.44,0.16 1.2,0.33 0.85,0.98 -0.31,0.97 -0.78,2.54 0.29,3.17 0.36,0.22 -0.14,0.88 0.17,1.23 0.08,0.63 0.62,0.62 1.07,0.75 0.62,0.54 1.45,0.56 2.11,0.93 0.74,0.44 -0.42,0.69 -0.75,0.83 -0.77,0.39 -1.54,-0.95 -2.18,-0.33 -0.32,0.93 1.39,0.61 1.06,1.55 -0.25,1.03 -0.69,2.28 -0.19,3.28 0.35,0.35 1.08,-0.03 1.33,0.25 -0.02,0.88 1,1.15 1.63,1.35 0.03,0.7 -0.64,0.98 -1.03,1.36 -0.19,0.68 0.69,0.61 1.05,0.72 0.11,0.81 0.68,1.24 1.45,1.13 0.78,0.62 0.25,1.87 0.58,2.72 0.32,1.25 1.05,2.35 1.2,3.64 0.23,0.6 0.73,1.03 0.75,1.71 0.3,0.53 0.64,1.19 1.12,1.54 0.71,-0.23 1.03,-1.22 1.92,-1.1 0.75,0.05 1.51,-0.43 2.2,-0.36 0.67,0.33 0.76,-0.83 0.88,-1.27 0.24,-0.54 -0.1,-1.45 0.33,-1.77 0.96,-0.09 2.39,-0.25 2.88,0.76 0.23,0.48 0.81,0.93 0.38,1.52 -0.87,0.9 0.04,0.97 0.85,0.68 0.73,-0.06 1.51,-0.09 2.14,-0.38 0.88,0.42 0.93,1.58 1.37,2.3 0.94,0.32 1.52,1.34 1.84,2.23 0.51,0.29 1.2,-0.83 1.66,-0.08 0.11,0.51 -0.87,1.24 0.03,1.53 0.63,0.5 1.05,-0.29 1.57,-0.47 0.8,0.17 1.2,-0.77 1.92,-0.92 0.12,-0.54 0.09,-1.15 0.5,-1.63 0.56,-0.74 0.25,-2.21 1.42,-2.35 0.42,0 0.35,1.16 0.93,0.73 0.13,-0.29 -0.2,-0.98 0.38,-0.74 0.57,0.24 0.81,-0.38 1.36,-0.27 0.51,-0.28 -0.21,-0.89 0.12,-1.32 0.07,-0.68 0.43,-1.42 1.24,-1.22 1.04,0.12 2.07,-0.05 3,-0.44 0.74,0.15 1.86,0.66 2.31,-0.24 0.71,-0.17 0.69,-0.95 0.79,-1.51 0.54,-1.15 1.7,-1.98 1.79,-3.35 0.03,-0.64 0.66,-0.95 1.19,-0.56 0.73,0.26 1.39,-0.3 2.13,-0.29 0.53,-0.09 1.02,-0.71 0.45,-1.09 -1.16,-0.84 -0.33,-3.01 1.08,-2.97 0.64,0.06 1.23,-0.14 1.78,-0.38 0.8,-0.01 0.64,-1.42 -0.14,-1.31 -0.62,-0.28 -1.07,-1 -0.53,-1.58 0.38,-0.37 0.24,-0.94 0.4,-1.33 0.41,-0.51 1.83,-0.04 1.58,-1 -0.35,-0.58 -1.42,-0.81 -0.95,-1.68 0.21,-0.52 1.08,0.01 1.49,-0.09 0.71,0.08 1.07,0.7 1.11,1.33 0.45,0.44 1.26,-0.25 0.67,-0.7 -0.56,-1.33 0.48,-2.56 1.24,-3.54 0.33,-0.78 -0.04,-1.77 0.58,-2.42 -0.09,-1.29 -1.55,-1.95 -2.18,-2.98 -0.49,-0.98 -1.68,0.05 -2.27,0.45 -0.8,0.36 -1.63,-0.71 -1.69,-1.28 0.27,-0.45 0.93,-1.37 0.06,-1.55 -0.38,-0.36 -1.47,-0.89 -0.65,-1.34 0.42,-0.5 1.59,-1.25 0.74,-1.91 -0.54,-0.48 -1.4,-1.4 -2.17,-0.92 -0.38,0.54 -1.63,0.77 -1.87,-0.08 -0.3,-0.35 -0.78,-0.42 -0.95,-0.93 -0.58,-0.73 -1.43,-0.11 -2.14,-0.09 -0.6,-0.47 -1.71,-0.67 -2.19,0.03 0,0.36 0.52,1.07 -0.16,1.1 -0.65,-0.02 -1.67,-0.33 -1.79,0.58 -0.53,-0.16 -1.34,-0.02 -1.41,0.7 0.04,0.48 -0.49,0.9 -0.76,0.33 -0.17,-0.7 -1.17,-1.16 -1.5,-0.3 -0.22,0.22 -0.18,1.1 -0.55,0.95 -0.4,-0.8 -0.82,-1.6 -1.37,-2.3 -0.02,-0.69 -0.76,-0.53 -1.15,-0.31 -0.47,-0.1 -1.08,-0.11 -1.16,0.51 -0.38,0.37 -0.83,0.7 -0.81,1.3 -0.12,0.3 -0.56,0.92 -0.72,0.29 -0.13,-0.49 -0.25,-1.09 -0.92,-1.07 -0.64,-0.07 -1.26,-0.22 -1.67,-0.71 -0.6,0.1 -0.36,-0.46 -0.57,-0.79 -0.26,-0.26 -0.74,-0.11 -0.85,-0.58 -0.86,-0.52 -1.31,0.78 -1.2,1.45 0.17,0.68 -0.45,1.07 -1.07,0.86 -0.96,-0.1 -1.84,-0.48 -2.8,-0.6 -0.45,-0.38 -0.73,-1.57 -1.52,-1.15 -0.32,0.44 -0.2,1.16 -0.84,1.28 -0.54,0.35 -0.91,1.83 -1.74,1.22 -0.91,-0.61 -1.4,-1.57 -1.53,-2.63 -0.16,-0.64 -0.63,-1.14 -1.31,-1.01 -1.03,-0.19 -2.11,-0.67 -2.45,-1.74 -0.08,-0.09 -0.21,-0.14 -0.33,-0.12 z",
					    "department-03" : "m 41.09,0.09 c -0.53,0.03 -0.65,0.93 -1.28,0.58 -1.07,-0.24 -1.29,1.09 -2.18,1.35 -0.68,0.38 -0.83,1.21 -1.57,1.57 -0.59,0.3 -0.37,1.08 -0.67,1.47 -0.82,-0.75 -2.14,-0.58 -2.85,0.25 -0.56,0.51 -1.31,0.26 -1.58,-0.42 -0.26,-0.45 -0.61,-1.5 -1.29,-0.94 -0.65,0.39 -0.38,1.55 -1.28,1.63 -0.49,0.33 -0.44,1.07 -1.07,1.29 -0.54,0.29 -0.85,0.95 -1.54,0.66 -0.62,0.1 -0.27,0.76 -0.06,1.06 0.07,0.49 -0.16,1.38 -0.8,0.88 -0.59,-0.44 -1.77,-0.28 -2.01,0.33 0.58,0.17 1.69,0.86 1,1.55 -0.36,0.28 -0.06,0.77 -0.23,1.04 -0.67,0.39 -0.15,1.28 0.46,1.35 0.61,0.77 0.55,1.86 0.72,2.79 -1.18,0.73 -2.34,1.71 -3.62,2.11 -0.29,-0.68 -0.88,-0.33 -1.32,-0.08 -0.47,0.1 -0.2,-0.76 -0.8,-0.58 -1.03,0.35 -2.03,0.8 -3.17,0.71 -1.3,0.06 -2.78,0.14 -3.58,1.33 -0.8,0.47 -0.02,1.59 -0.84,2.01 -0.42,0.05 -0.96,-0.06 -1.15,0.48 -0.78,1.48 -0.9,3.37 -0.4,4.96 0.26,0.38 0.79,0.29 1.15,0.57 0.49,0.09 1.26,0.02 1.06,0.79 0.02,0.4 -0.72,0.13 -0.85,0.54 -1.01,0.83 0.27,2.03 1.17,2.2 0.58,-0.08 0.87,0.54 1.33,0.59 0.39,-0.14 0.38,-1.36 0.9,-0.77 0.76,0.62 1.67,1.41 1.25,2.52 0.36,0.53 0.91,-0.64 1.46,-0.19 0.81,0.23 1.7,0.87 1.45,1.84 0.14,1.11 1.68,1.3 1.67,2.49 0.4,1.14 -0,3.01 1.48,3.41 0.81,0.19 0.41,1.35 0.75,1.93 0.25,0.78 1.04,1.13 1.79,1.18 0.65,0.32 1.81,1 2.22,-0.03 0.46,-0.9 0.75,-1.9 1.09,-2.8 0.55,-0.73 1.89,-0.29 2.08,-1.36 0.24,-0.68 -0.44,-1.52 0.43,-1.96 0.66,-0.22 0.95,0.83 1.63,0.76 0.55,0.39 1.4,1.36 2.04,0.56 0.42,-0.83 -0.03,-1.98 0.37,-2.71 0.72,-0.31 1.49,-1.18 2.3,-0.64 1.07,0.12 2.57,-0.1 3.28,0.88 -0.24,0.56 -0.03,1.41 -0.79,1.61 -0.76,0.37 -0.44,1.16 -0.29,1.75 -0.13,0.49 -0.09,1.14 0.58,1.12 0.68,-0.1 1.21,0.33 1.13,1.02 0.09,0.86 0.18,2.33 1.42,2.14 0.89,0.14 1.21,1.58 2.25,1.17 0.81,0.52 1.65,-0.25 2.49,-0.28 0.45,0.5 0.3,1.19 0.45,1.75 0.87,0.19 1.51,1 2.48,1.02 0.76,0.25 1.24,-0.53 2.01,-0.38 0.48,-0.11 0.79,0.09 1.13,0.28 0.44,-0.22 0.55,0.55 1.06,0.34 1.38,-0.06 2.97,-0.26 4,0.88 0.96,0.41 1.66,-0.65 2.44,-0.96 0.64,0.07 1.32,-0.9 1.79,-0.16 0.31,0.43 0.85,0.4 1.28,0.42 0.72,0.93 0.57,2.17 0.55,3.26 1.03,0.14 2.05,-0.24 2.95,-0.62 0.45,0.01 0.76,0.46 1.28,0.23 0.59,0.08 1.31,-0.75 1.72,0 0.77,0.99 1.15,2.22 1.65,3.32 0.67,0.5 2.27,0.29 2.14,1.5 0.41,0.47 0.99,-0.52 0.95,-0.95 -0.15,-0.63 0.53,-1.04 1.07,-0.73 0.48,0.22 1.27,0.4 1.28,-0.34 0.41,-0.77 1.09,0.48 1.68,-0.03 0.66,-0.43 2.17,-0.85 1.53,-1.93 -0.55,-1.45 -0.99,-3.06 -0.37,-4.56 0.35,-0.94 -0.22,-1.78 -0.75,-2.44 -0.09,-0.98 -0.2,-2.05 -0.29,-3.01 0.9,-0.02 0.57,-0.74 0.19,-1.26 -0.62,-1 0.1,-2.51 -0.98,-3.26 -0.34,-0.41 -0.36,-1.4 0.42,-1.13 0.62,0.33 1.04,-0.24 1.05,-0.81 0.86,-0.77 2.51,-0.06 3.19,-1.15 0.39,-0.12 0.9,-0.24 0.79,-0.8 0.24,-1.13 2.3,-0.37 2.35,-1.71 -0.01,-1.08 1.5,-0.38 2.04,-0.87 -0.47,-0.98 0.15,-2.27 -0.18,-3.37 -0.22,-0.75 -0.56,-1.54 -0.06,-2.26 -0.09,-0.66 0.49,-1.17 0.25,-1.83 0.92,-0.68 0.27,-2.39 -0.81,-2.61 -0.47,-0.05 -0.91,-0.14 -0.99,-0.67 -0.62,-0.48 -1.88,-0.87 -2.29,0.07 -0.58,0.43 -1.56,-0.12 -1.78,-0.72 0.04,-0.44 0.16,-1.45 -0.59,-1.13 -0.61,-0.09 -0.16,-0.76 -0.46,-1.01 -0.68,-0.03 -1.24,0.99 -1.91,0.34 -0.7,-0.25 -1.13,-1.1 -1.96,-0.88 -0.71,-0.06 -1.29,-0.9 -0.77,-1.51 0.12,-0.95 0.28,-2.27 -0.52,-2.97 -0.67,-0.08 -0.6,-0.63 -0.36,-1.08 -0.11,-0.87 -0.73,-1.6 -0.95,-2.44 -0.41,-0.57 -1.28,-0.79 -1.36,-1.54 -0.43,-0.32 -0.76,-0.7 -0.76,-1.26 -0.23,-0.42 -0.82,-0.6 -0.66,-1.2 -0.07,-0.72 -0.65,-1.29 -0.65,-2 -0.38,-0.23 -0.96,-0.06 -1.13,-0.6 -0.76,-0.3 -0.78,0.93 -0.41,1.32 0.52,0.51 0.35,1.1 -0.32,1.27 -0.46,0.18 -1.77,-0.11 -1.37,0.76 0.22,0.53 0.68,1.24 -0.05,1.6 -0.45,0.63 -0.72,-0.73 -1.25,-0.14 -0.73,0.55 -1.34,1.34 -1.72,2.1 -0.7,0.19 -2.06,0.06 -1.81,-0.97 0.28,-0.69 0.26,-1.75 -0.66,-1.9 -0.06,-0.42 -0.09,-1.15 -0.73,-0.99 -0.6,-0.11 -1.41,-0.35 -1.66,0.43 -0.42,1.36 -2.42,1.83 -3.19,0.53 -0.36,-0.46 -0.4,-1.37 -1.24,-1.2 -0.93,-0.04 -1.39,0.93 -2.18,1.27 -0.52,0.67 -1.46,1.45 -2.3,0.76 -1.65,-0.71 -2.01,-3.06 -3.96,-3.3 -1.62,-0.6 -2.82,-2.05 -3.15,-3.73 -0.68,-0.77 -1.92,-0.52 -2.83,-0.76 l -0.03,0.01 z"
					}
				}
			}
		}
	);
})(jQuery);