/*
 * Decompiled with CFR 0.152.
 */
package tr.view.actions.screens.dao;

import au.com.thinkingrock.xsd.tr.view.actions.screens.Column;
import au.com.thinkingrock.xsd.tr.view.actions.screens.ColumnID;
import au.com.thinkingrock.xsd.tr.view.actions.screens.Columns;
import au.com.thinkingrock.xsd.tr.view.actions.screens.Filter;
import au.com.thinkingrock.xsd.tr.view.actions.screens.FilterID;
import au.com.thinkingrock.xsd.tr.view.actions.screens.Filters;
import au.com.thinkingrock.xsd.tr.view.actions.screens.Screen;
import au.com.thinkingrock.xsd.tr.view.actions.screens.Screens;
import au.com.thinkingrock.xsd.tr.view.actions.screens.SortColumn;
import au.com.thinkingrock.xsd.tr.view.actions.screens.SortColumns;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Vector;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.lang.StringEscapeUtils;
import tr.datastore.DataStore;
import tr.datastore.DataStoreLookup;
import tr.util.Observable;
import tr.util.Utils;
import tr.view.actions.screens.ActionsScreen;
import tr.view.actions.screens.ActionsScreens;
import tr.view.actions.screens.columns.ActionsColumn;
import tr.view.actions.screens.dao.ScreensDAO;
import tr.view.actions.screens.filters.ActionsFilter;
import tr.view.actions.screens.filters.FilterFactory;

final class ScreensDAOJAXB
implements ScreensDAO {
    private static final Logger LOG = Logger.getLogger("tr.view.actions");
    private static final String FILENAME = "ReviewActions.xml";
    private static final String ENCODING = "UTF-8";
    private static ScreensDAO instance;
    private ActionsScreens actionsScreens = null;

    public static ScreensDAO getInstance() {
        if (instance == null) {
            instance = new ScreensDAOJAXB();
        }
        return instance;
    }

    private ScreensDAOJAXB() {
    }

    public ActionsScreens getData() {
        LOG.info("ScreensDAOJAXB.getData()");
        if (this.actionsScreens == null) {
            if (this.hasPersistantData()) {
                try {
                    this.restore();
                }
                catch (Exception ex) {
                    LOG.severe("Failed to restore review actions screens. " + ex.getMessage());
                }
            }
            if (this.actionsScreens == null) {
                this.actionsScreens = new ActionsScreens();
            }
        }
        return this.actionsScreens;
    }

    public boolean hasPersistantData() {
        File file = this.getFile();
        return file != null && file.exists();
    }

    private File getFile() {
        DataStore ds = (DataStore)DataStoreLookup.instance().lookup(DataStore.class);
        if (ds != null) {
            try {
                File parent = new File(ds.getPath()).getParentFile();
                return new File(parent, FILENAME);
            }
            catch (Exception ex) {
                LOG.severe("Failed to get file. " + ex.getMessage());
            }
        }
        return null;
    }

    public void persist() throws Exception {
        LOG.info("ScreensDAOJAXB.persist()");
        if (this.actionsScreens == null) {
            return;
        }
        File file = this.getFile();
        if (file == null) {
            LOG.severe("File is null.");
            return;
        }
        if (!file.exists()) {
            file.createNewFile();
        }
        if (!file.canWrite()) {
            LOG.severe("Can not write to file: " + file);
            return;
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), ENCODING));
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Screens.class});
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal((Object)this.toXMLScreens(this.actionsScreens), (Writer)writer);
        ((Writer)writer).close();
    }

    public void restore() throws Exception {
        File file = this.getFile();
        if (file == null || !file.exists()) {
            LOG.severe("File does not exist: " + file);
            return;
        }
        LOG.info("ScreensDAOJAXB.restore() - Reading file: " + file);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), ENCODING));
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Screens.class});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        Screens screens = (Screens)unmarshaller.unmarshal((Reader)reader);
        ((Reader)reader).close();
        this.actionsScreens = this.toActionsScreens(screens);
    }

    private Screens toXMLScreens(ActionsScreens actionScreens) {
        if (this.actionsScreens == null) {
            return new Screens();
        }
        Screens screens = new Screens();
        for (ActionsScreen as : actionScreens.getScreens().list()) {
            String name = StringEscapeUtils.escapeXml((String)as.getKey());
            Screen screen = new Screen(name);
            for (byte columnIndex : as.getColumnOrder()) {
                ActionsColumn ac = (ActionsColumn)as.getColumns().get((int)columnIndex);
                if (!ac.isVisible()) continue;
                Column c = new Column();
                c.setColumnID(ColumnID.fromValue(ac.getColumnID()));
                c.setWidth(ac.getWidth());
                screen.getColumns().getColumns().add(c);
            }
            byte[] sortColumns = as.getSortColumns();
            byte[] sortStates = as.getSortStates();
            for (int i = 0; i < sortColumns.length; ++i) {
                SortColumn sc = new SortColumn();
                sc.setColumnID(ColumnID.fromValue(ActionsColumn.getColumnID(sortColumns[i])));
                sc.setDescending(sortStates[i] == 2);
                screen.getSortColumns().getSortColumns().add(sc);
            }
            screen.getFilters().setShow(as.isShowFilters());
            for (ActionsFilter af : as.getFilters()) {
                if (!af.isUsed()) continue;
                Filter f = new Filter();
                f.setFilterID(FilterID.fromValue(FilterFactory.getID(af.getIndex())));
                f.setVisible(af.isShown());
                f.setExcludeNulls(af.isExcludeNulls());
                if (af.getSerialValues() != null) {
                    for (String value : af.getSerialValues()) {
                        f.getValues().add(value);
                    }
                }
                screen.getFilters().getFilters().add(f);
            }
            screens.getScreens().add(screen);
        }
        return screens;
    }

    private ActionsScreens toActionsScreens(Screens screens) {
        ActionsScreens scrns = new ActionsScreens();
        for (Screen screen : screens.getScreens()) {
            String name = StringEscapeUtils.unescapeXml((String)screen.getName());
            ActionsScreen actionsScreen = ActionsScreen.create(name);
            Vector<Byte> columnOrderList = new Vector<Byte>();
            Columns columns = screen.getColumns();
            if (columns != null) {
                for (Column column : columns.getColumns()) {
                    byte index = column.getColumnID().index();
                    columnOrderList.add(index);
                    ActionsColumn actionsColumn = (ActionsColumn)actionsScreen.getColumns().get((int)index);
                    actionsColumn.setVisible(true);
                    actionsColumn.setWidth(column.getWidth());
                }
            }
            actionsScreen.setColumnOrder(Utils.byteArray(columnOrderList));
            Filters filters = screen.getFilters();
            if (filters != null) {
                actionsScreen.setShowFilters(filters.isShow());
                for (Filter filter : filters.getFilters()) {
                    byte index = filter.getFilterID().index();
                    ActionsFilter actionsFilter = actionsScreen.getFilters().get(index);
                    actionsFilter.setUsed(true);
                    actionsFilter.setShown(filter.isVisible());
                    actionsFilter.setExcludeNulls(filter.isExcludeNulls());
                    actionsFilter.setSerialValues(filter.getValues().toArray(new String[0]));
                }
            }
            Vector<Byte> sortColumnList = new Vector<Byte>();
            Vector<Byte> sortStatusList = new Vector<Byte>();
            SortColumns sortColumns = screen.getSortColumns();
            if (sortColumns != null) {
                for (SortColumn sortColumn : screen.getSortColumns().getSortColumns()) {
                    sortColumnList.add(sortColumn.getColumnID().index());
                    sortStatusList.add(sortColumn.isDescending() != false ? (byte)2 : 1);
                }
            }
            actionsScreen.setSortColumns(Utils.byteArray(sortColumnList));
            actionsScreen.setSortStatus(Utils.byteArray(sortStatusList));
            scrns.getScreens().add((Observable)actionsScreen);
        }
        return scrns;
    }

    public void delete() {
        File file = this.getFile();
        if (file != null) {
            file.delete();
        }
    }

    public void reset() {
        LOG.info("ScreensDAOJAXB.reset()");
        this.actionsScreens = null;
    }
}

