/*
 * Decompiled with CFR 0.152.
 */
package tr.view.actions.screens;

import au.com.thinkingrock.tr.resource.Icons;
import au.com.trgtd.tr.appl.Constants;
import ca.odell.glazedlists.gui.AdvancedTableFormat;
import ca.odell.glazedlists.gui.WritableTableFormat;
import java.awt.Color;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import tr.model.action.Action;
import tr.model.action.ActionState;
import tr.model.action.ActionStateDelegated;
import tr.model.action.ActionStateScheduled;
import tr.model.criteria.Value;
import tr.model.project.Project;
import tr.model.thought.Thought;
import tr.model.topic.Topic;
import tr.swing.StyledDate;
import tr.swing.StyledString;
import tr.util.DateNoTime;
import tr.util.DateUtils;
import tr.view.actions.screens.ActionsScreen;
import tr.view.actions.screens.StyledValue;
import tr.view.actions.screens.columns.ActionsColumn;

public class ReviewActionsTableFormat
implements AdvancedTableFormat,
WritableTableFormat {
    private final ActionsScreen screen;

    public ReviewActionsTableFormat(ActionsScreen screen) {
        this.screen = screen;
    }

    public int getColumnCount() {
        return this.screen.getColumns().size();
    }

    public String getColumnName(int column) {
        try {
            return ((ActionsColumn)this.screen.getColumns().get(column)).getColumnName();
        }
        catch (IndexOutOfBoundsException ex) {
            throw new IllegalStateException();
        }
    }

    public Object getColumnValue(Object object, int column) {
        ActionsColumn field;
        if (!(object instanceof Action)) {
            throw new IllegalStateException("Row data missing.");
        }
        Action action = (Action)object;
        Project project = (Project)action.getParent();
        try {
            field = (ActionsColumn)this.screen.getColumns().get(column);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new IllegalStateException("Field missing.");
        }
        switch (field.getColumnIndex()) {
            case 15: {
                if (action.isStateScheduled()) {
                    return this.getStyledDate(null, false, action);
                }
                return this.getStyledDate(action.getStartDate(), false, action);
            }
            case 16: {
                Date date = action.isStateScheduled() ? null : action.getDueDate();
                Color bg = action.getTopic().getBackground();
                Color fg = action.getTopic().getForeground();
                if (date != null) {
                    Date today = Calendar.getInstance().getTime();
                    if (DateUtils.isBeforeDay((Date)date, (Date)today)) {
                        fg = Constants.COLOR_DATE_PAST;
                    } else if (DateUtils.isSameDay((Date)date, (Date)today)) {
                        fg = Constants.COLOR_DATE_TODAY;
                    } else if (DateUtils.isWithinDaysFuture((Date)date, (int)7)) {
                        fg = Constants.COLOR_DATE_WEEK;
                    }
                }
                return this.getStyledDate(date, false, action.isDone(), fg, bg);
            }
            case 6: {
                Date date = action.getActionDate();
                boolean time = !(date instanceof DateNoTime);
                Color bg = action.getTopic().getBackground();
                Color fg = action.getTopic().getForeground();
                if (date != null) {
                    Date today = Calendar.getInstance().getTime();
                    if (DateUtils.isBeforeDay((Date)date, (Date)today)) {
                        fg = Constants.COLOR_DATE_PAST;
                    } else if (DateUtils.isSameDay((Date)date, (Date)today)) {
                        fg = Constants.COLOR_DATE_TODAY;
                    } else if (DateUtils.isWithinDaysFuture((Date)date, (int)7)) {
                        fg = Constants.COLOR_DATE_WEEK;
                    }
                }
                return this.getStyledDate(date, time, action.isDone(), fg, bg);
            }
            case 7: {
                return this.getStyledString(action.getContext().toString(), action);
            }
            case 4: {
                return this.getStyledDate(action.getCreated(), false, action);
            }
            case 3: {
                ActionState state = action.getState();
                String s = action.isStateDelegated() ? ((ActionStateDelegated)state).getTo() : "";
                return this.getStyledString(s, action);
            }
            case 2: {
                return this.getStyledString(action.getDescription(), action);
            }
            case 1: {
                return new Boolean(action.isDone());
            }
            case 5: {
                return this.getStyledDate(action.getDoneDate(), false, action);
            }
            case 8: {
                return this.getStyledValue(action.getTime(), action);
            }
            case 9: {
                return this.getStyledValue(action.getEnergy(), action);
            }
            case 10: {
                return this.getStyledValue(action.getPriority(), action);
            }
            case 13: {
                if (action.isSingleAction()) {
                    Thought thought = action.getThought();
                    if (thought != null) {
                        return this.getStyledString(thought.getDescription(), action.isDone(), thought.getTopic());
                    }
                    return this.getStyledString("", action.isDone(), action.getTopic());
                }
                if (project != null) {
                    return this.getStyledString(project.getDescription(), project.isDone(), project.getTopic());
                }
                return this.getStyledString("", project.isDone(), project.getTopic());
            }
            case 12: {
                if (action.isSingleAction()) {
                    Thought thought = action.getThought();
                    return thought == null ? null : Icons.Thought;
                }
                return project == null ? null : project.getIcon(false);
            }
            case 14: {
                if (action.isSingleAction()) {
                    Thought thought = action.getThought();
                    if (thought != null) {
                        return this.getStyledString(thought.getTopic().toString(), action.isDone(), thought.getTopic());
                    }
                    return this.getStyledString("", action.isDone(), action.getTopic());
                }
                if (project != null) {
                    return this.getStyledString(project.getTopic().toString(), project.isDone(), project.getTopic());
                }
                return this.getStyledString("", project.isDone(), project.getTopic());
            }
            case 0: {
                return action.getIcon(false);
            }
            case 11: {
                return this.getStyledString(action.getTopic().toString(), action);
            }
            case 17: {
                if (!action.isStateDelegated()) {
                    return this.getStyledDate(null, false, action);
                }
                Color bg = action.getTopic().getBackground();
                Color fg = action.getTopic().getForeground();
                Date date = ((ActionStateDelegated)action.getState()).getDate();
                if (date != null) {
                    Date today = Calendar.getInstance().getTime();
                    if (DateUtils.isBeforeDay((Date)date, (Date)today)) {
                        fg = Constants.COLOR_DATE_PAST;
                    } else if (DateUtils.isSameDay((Date)date, (Date)today)) {
                        fg = Constants.COLOR_DATE_TODAY;
                    } else if (DateUtils.isWithinDaysFuture((Date)date, (int)7)) {
                        fg = Constants.COLOR_DATE_WEEK;
                    }
                }
                return this.getStyledDate(date, false, action.isDone(), fg, bg);
            }
            case 18: {
                if (!action.isStateScheduled()) {
                    return this.getStyledDate(null, false, action);
                }
                Color bg = action.getTopic().getBackground();
                Color fg = action.getTopic().getForeground();
                Date date = ((ActionStateScheduled)action.getState()).getDate();
                if (date != null) {
                    Date today = Calendar.getInstance().getTime();
                    if (DateUtils.isBeforeDay((Date)date, (Date)today)) {
                        fg = Constants.COLOR_DATE_PAST;
                    } else if (DateUtils.isSameDay((Date)date, (Date)today)) {
                        fg = Constants.COLOR_DATE_TODAY;
                    } else if (DateUtils.isWithinDaysFuture((Date)date, (int)7)) {
                        fg = Constants.COLOR_DATE_WEEK;
                    }
                }
                return this.getStyledDate(date, true, action.isDone(), fg, bg);
            }
            case 19: {
                if (!action.isStateScheduled()) {
                    return this.getStyledString("", false, action.getTopic());
                }
                Color bg = action.getTopic().getBackground();
                Color fg = action.getTopic().getForeground();
                ActionStateScheduled ass = (ActionStateScheduled)action.getState();
                int hrs = ass.getDurationHours();
                String hrsString = hrs < 10 ? "0" + String.valueOf(hrs) : String.valueOf(hrs);
                int mns = ass.getDurationMinutes();
                String mnsString = mns < 10 ? "0" + String.valueOf(mns) : String.valueOf(mns);
                return this.getStyledString(hrsString + ":" + mnsString, action);
            }
            case 20: {
                if (project == null) {
                    return this.getStyledString("", false, Color.black, Color.white);
                }
                return this.getStyledString(this.getPath(project, ""), false, Color.BLACK, Color.WHITE);
            }
            case 21: {
                if (action.isSingleAction()) {
                    Thought thought = action.getThought();
                    if (thought == null) {
                        return this.getStyledString("", false, Color.black, Color.white);
                    }
                    return this.getStyledString(thought.getDescription(), false, thought.getTopic());
                }
                if (project == null) {
                    return this.getStyledString("", false, Color.black, Color.white);
                }
                Project topProject = this.getTopProject(project);
                Color bg = topProject.getTopic().getBackground();
                Color fg = topProject.getTopic().getForeground();
                return this.getStyledString(topProject.getDescription(), topProject.isDone(), fg, bg);
            }
        }
        return "";
    }

    private Project getTopProject(Project project) {
        Project parent = (Project)project.getParent();
        if (parent.isRoot()) {
            return project;
        }
        return this.getTopProject(parent);
    }

    private String getPath(Project project, String path) {
        path = path.length() > 0 ? project.getDescription() + "/" + path : project.getDescription();
        Project parent = (Project)project.getParent();
        if (!parent.isRoot()) {
            return this.getPath(parent, path);
        }
        return path;
    }

    public Class getColumnClass(int column) {
        try {
            return ((ActionsColumn)this.screen.getColumns().get(column)).getColumnClass();
        }
        catch (IndexOutOfBoundsException ex) {
            throw new IllegalStateException();
        }
    }

    public Comparator getColumnComparator(int column) {
        try {
            return ((ActionsColumn)this.screen.getColumns().get(column)).getColumnComparator();
        }
        catch (IndexOutOfBoundsException ex) {
            throw new IllegalStateException();
        }
    }

    public int getWidth(int column) {
        try {
            return ((ActionsColumn)this.screen.getColumns().get(column)).getWidth();
        }
        catch (IndexOutOfBoundsException ex) {
            throw new IllegalStateException();
        }
    }

    public int getMaxWidth(int column) {
        try {
            return ((ActionsColumn)this.screen.getColumns().get(column)).getMaximumWidth();
        }
        catch (IndexOutOfBoundsException ex) {
            throw new IllegalStateException();
        }
    }

    public int getMinWidth(int column) {
        try {
            return ((ActionsColumn)this.screen.getColumns().get(column)).getMinimumWidth();
        }
        catch (IndexOutOfBoundsException ex) {
            throw new IllegalStateException();
        }
    }

    public boolean isResizable(int column) {
        try {
            return ((ActionsColumn)this.screen.getColumns().get(column)).isResizable();
        }
        catch (IndexOutOfBoundsException ex) {
            throw new IllegalStateException();
        }
    }

    public boolean isVisible(int column) {
        try {
            return ((ActionsColumn)this.screen.getColumns().get(column)).isVisible();
        }
        catch (IndexOutOfBoundsException ex) {
            throw new IllegalStateException();
        }
    }

    public Byte getID(int column) {
        try {
            return new Byte(((ActionsColumn)this.screen.getColumns().get(column)).getColumnIndex());
        }
        catch (IndexOutOfBoundsException ex) {
            throw new IllegalStateException();
        }
    }

    private StyledDate getStyledDate(Date date, boolean showTime, Action action) {
        StyledDate sd = new StyledDate(Constants.DATE_FORMAT_FIXED, Constants.DATE_TIME_FORMAT_FIXED);
        sd.setDate(date);
        sd.setShowTime(showTime);
        sd.setStrike(action.isDone());
        sd.setForeground(action.getTopic().getForeground());
        sd.setBackground(action.getTopic().getBackground());
        return sd;
    }

    private StyledDate getStyledDate(Date date, boolean t, boolean d, Color fg, Color bg) {
        StyledDate sd = new StyledDate(Constants.DATE_FORMAT_FIXED, Constants.DATE_TIME_FORMAT_FIXED);
        sd.setDate(date);
        sd.setShowTime(t);
        sd.setStrike(d);
        sd.setForeground(fg);
        sd.setBackground(bg);
        return sd;
    }

    private StyledString getStyledString(String s, Action action) {
        Topic t = action.getTopic();
        return this.getStyledString(s, action.isDone(), t.getForeground(), t.getBackground());
    }

    private StyledString getStyledString(String s, boolean d, Topic t) {
        return this.getStyledString(s, d, t.getForeground(), t.getBackground());
    }

    private StyledString getStyledString(String s, boolean d, Color fg, Color bg) {
        StyledString ss = new StyledString();
        ss.setString(s);
        ss.setStrike(d);
        ss.setForeground(fg);
        ss.setBackground(bg);
        return ss;
    }

    private StyledValue getStyledValue(Value value, Action action) {
        Topic topic = action.getTopic();
        StyledValue styledValue = new StyledValue(value);
        styledValue.setStrike(action.isDone());
        styledValue.setForeground(topic.getForeground());
        styledValue.setBackground(topic.getBackground());
        return styledValue;
    }

    public boolean isEditable(Object baseObject, int column) {
        return ((ActionsColumn)this.screen.getColumns().get(column)).getColumnIndex() == 1;
    }

    public Object setColumnValue(Object baseObject, Object editedValue, int column) {
        assert (((ActionsColumn)this.screen.getColumns().get(column)).getColumnIndex() == 1);
        assert (baseObject instanceof Action);
        assert (editedValue instanceof Boolean);
        Action action = (Action)baseObject;
        boolean value = (Boolean)editedValue;
        if (action.canSetDone(value)) {
            action.setDone(value);
            return action;
        }
        return null;
    }
}

