/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.renderable;

import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;
import java.util.Map;
import java.util.Vector;
import org.apache.batik.ext.awt.image.renderable.Filter;

public class DeferRable
implements Filter {
    Filter src;
    Rectangle2D bounds;
    Map props;

    public synchronized Filter getSource() {
        while (this.src == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.src;
    }

    public synchronized void setSource(Filter filter) {
        if (this.src != null) {
            return;
        }
        this.src = filter;
        this.bounds = filter.getBounds2D();
        this.notifyAll();
    }

    public synchronized void setBounds(Rectangle2D rectangle2D) {
        if (this.bounds != null) {
            return;
        }
        this.bounds = rectangle2D;
        this.notifyAll();
    }

    public synchronized void setProperties(Map map) {
        this.props = map;
        this.notifyAll();
    }

    public long getTimeStamp() {
        return this.getSource().getTimeStamp();
    }

    public Vector getSources() {
        return this.getSource().getSources();
    }

    public boolean isDynamic() {
        return this.getSource().isDynamic();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Rectangle2D getBounds2D() {
        DeferRable deferRable = this;
        // MONITORENTER : deferRable
        while (this.src == null && this.bounds == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        // MONITOREXIT : deferRable
        if (this.src == null) return this.bounds;
        return this.src.getBounds2D();
    }

    public float getMinX() {
        return (float)this.getBounds2D().getX();
    }

    public float getMinY() {
        return (float)this.getBounds2D().getY();
    }

    public float getWidth() {
        return (float)this.getBounds2D().getWidth();
    }

    public float getHeight() {
        return (float)this.getBounds2D().getHeight();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Object getProperty(String string) {
        DeferRable deferRable = this;
        // MONITORENTER : deferRable
        while (this.src == null && this.props == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        // MONITOREXIT : deferRable
        if (this.src == null) return this.props.get(string);
        return this.src.getProperty(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public String[] getPropertyNames() {
        DeferRable deferRable = this;
        // MONITORENTER : deferRable
        while (this.src == null && this.props == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        // MONITOREXIT : deferRable
        if (this.src != null) {
            return this.src.getPropertyNames();
        }
        String[] stringArray = new String[this.props.size()];
        this.props.keySet().toArray(stringArray);
        return stringArray;
    }

    public RenderedImage createDefaultRendering() {
        return this.getSource().createDefaultRendering();
    }

    public RenderedImage createScaledRendering(int n, int n2, RenderingHints renderingHints) {
        return this.getSource().createScaledRendering(n, n2, renderingHints);
    }

    public RenderedImage createRendering(RenderContext renderContext) {
        return this.getSource().createRendering(renderContext);
    }

    public Shape getDependencyRegion(int n, Rectangle2D rectangle2D) {
        return this.getSource().getDependencyRegion(n, rectangle2D);
    }

    public Shape getDirtyRegion(int n, Rectangle2D rectangle2D) {
        return this.getSource().getDirtyRegion(n, rectangle2D);
    }
}

