/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Window;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.Constants;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.view.ModeView;
import org.netbeans.core.windows.view.ViewElement;
import org.netbeans.core.windows.view.dnd.TopComponentDroppable;
import org.netbeans.core.windows.view.dnd.WindowDnDManager;
import org.netbeans.core.windows.view.ui.AbstractModeContainer;
import org.netbeans.core.windows.view.ui.ModeComponent;
import org.netbeans.core.windows.view.ui.Tabbed;
import org.netbeans.core.windows.view.ui.tabcontrol.TabbedAdapter;
import org.openide.windows.TopComponent;

public final class DefaultSplitContainer
extends AbstractModeContainer {
    private final JPanel panel = new ModePanel(this);

    public DefaultSplitContainer(ModeView modeView, WindowDnDManager windowDnDManager, int n) {
        super(modeView, windowDnDManager, n);
        this.panel.add(this.tabbedHandler.getComponent(), "Center");
    }

    public void requestAttention(TopComponent topComponent) {
        this.tabbedHandler.requestAttention(topComponent);
    }

    public void cancelRequestAttention(TopComponent topComponent) {
        this.tabbedHandler.cancelRequestAttention(topComponent);
    }

    protected Component getModeComponent() {
        return this.panel;
    }

    protected Tabbed createTabbed() {
        TabbedAdapter tabbedAdapter = this.getKind() == 1 ? new TabbedAdapter(1) : new TabbedAdapter(0);
        return tabbedAdapter;
    }

    protected void updateTitle(String string) {
    }

    protected void updateActive(boolean bl) {
        Window window;
        if (bl && (window = SwingUtilities.getWindowAncestor(this.panel)) != null && !window.isActive() && WindowManagerImpl.getInstance().getEditorAreaState() == 1) {
            window.toFront();
        }
    }

    public boolean isActive() {
        Window window = SwingUtilities.getWindowAncestor(this.panel);
        return window != null ? window.isActive() : false;
    }

    protected boolean isAttachingPossible() {
        return true;
    }

    protected TopComponentDroppable getModeDroppable() {
        return (ModePanel)this.panel;
    }

    private static class ModePanel
    extends JPanel
    implements ModeComponent,
    TopComponentDroppable {
        private final AbstractModeContainer abstractModeContainer;

        public ModePanel(AbstractModeContainer abstractModeContainer) {
            super(new BorderLayout());
            this.abstractModeContainer = abstractModeContainer;
            this.enableEvents(16L);
        }

        public ModeView getModeView() {
            return this.abstractModeContainer.getModeView();
        }

        public int getKind() {
            return this.abstractModeContainer.getKind();
        }

        public Shape getIndicationForLocation(Point point) {
            return this.abstractModeContainer.getIndicationForLocation(point);
        }

        public Object getConstraintForLocation(Point point) {
            return this.abstractModeContainer.getConstraintForLocation(point);
        }

        public Component getDropComponent() {
            return this.abstractModeContainer.getDropComponent();
        }

        public ViewElement getDropViewElement() {
            return this.abstractModeContainer.getDropModeView();
        }

        public boolean canDrop(TopComponent topComponent, Point point) {
            return this.abstractModeContainer.canDrop(topComponent);
        }

        public boolean supportsKind(int n, TopComponent topComponent) {
            if (Constants.SWITCH_MODE_ADD_NO_RESTRICT || WindowManagerImpl.getInstance().isTopComponentAllowedToMoveAnywhere(topComponent)) {
                return true;
            }
            boolean bl = n == 0 || n == 2;
            boolean bl2 = this.getKind() == 0 || this.getKind() == 2;
            return bl == bl2;
        }
    }
}

