######################################################################
package Net::Amazon::Validate::ItemSearch;
######################################################################
use warnings;
use strict;

use Data::Dumper;
use Log::Log4perl qw(:easy);

use warnings; 
use strict;

##################################################
sub factory {
##################################################
    my(%options) = (@_);

    DEBUG(sub {"Validate::Itemsearch factory options=" . Data::Dumper::Dumper(\%options) . "\n"});

# NOTE: if you want to support multiple versions of the WSDL then add this back.
#     # Transform 2005-10-05 into V2005_10_05 to ensure its a valid module name.
#     my $wsdl_version = $Net::Amazon::WsdlVersion;
#     my $ver = "V$wsdl_version";
#     $ver =~ s|-|_|g;

    my $class = 'Net::Amazon::Validate::ItemSearch::';
#     $class .= $ver;
#     $class .= "::";
    $class .= $Net::Amazon::Locale;
    $class .= "::";
    $class .= $options{search_index};

    eval "require $class";	
    
    my $obj = $class->new();

    return $obj;
}

1;
__END__

=head1 NAME

Net::Amazon::Validate::ItemSearch - Validate ItemSearch requests.

=head1 SYNOPSIS

  Net::Amazon::Validate::ItemSearch;

  my $valid   = Net::Amazon::Validate::ItemSearch::factory(search_index => 'Actor');
  my $option  = $itemsearch_valid->user_or_default($input);
  my $default = $itemsearch_valid->default();

=head1 DESCRIPTION

C<Net::Amazon::Validate::ItemSearch> is a class used to verify ItemSearch
operation based on the current version of the WSDL and locale.  For example if
an Artist search is executed the user can search against Classical, Merchants,
or Music.

=head2 METHODS

=over 4

=item factory(search_index => type)

Constructs a new C<Net::Amazon::Validate::ItemSearch> object, used to validate
user input for a SearchIndex.  Valid types include Actor, Artist,
AudienceRating, Author Brand, BrowseNode, City, Composer, Condition, Conductor,
Count, Cuisine, DeliveryMethod, Director, ISPUPostalCode, ItemPage, Keywords,
MPAARating, Manufacturer, MaximumPrice, MerchantId, MinimumPrice, MusicLabel,
Neighborhood, Orchestra, Power, Publisher, Sort, TextStream and Title.  Which
departments these search indexes are valid for is dependent upon locale.

=item default()

Return the default value for a given SearchIndex.  Default are determined in
order of preference and existence from the following list: Books, Music, DVD,
Software.  If none of those items are valid for a given SearchIndex then the
first valid department of said SearchIndex is used.

=item user_or_default( $input )

If user input is specified it validates the input, and return it, otherwise it
returns the default value for the SearchIndex.

=back

=head1 AUTHORS

Christopher Boumenot, E<lt>boumenot@gmail.comE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright 2006 by Christopher Boumenot, E<lt>boumenot@gmail.comE<gt>

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself. 

=cut


__END__

=head1 NAME

Net::Amazon::Validate::ItemSearch - Validate user supplied options against
known valid options.

=head1 SYNOPSIS

  use Net::Amazon::Validate::ItemSearch;

  # ...

  my $valid = Net::Amazon::Validate::ItemSearch::factory(search_index => 'Actor');
  $valid->user_or_default($input);
  $valid->default();

=head1 DESCRIPTION

=head2 METHODS

=over 4

=item Asin()

The item's ASIN number.

=back

Please check the subclasses of C<Net::Amazon::Validate> for specialized 
methods.

=head1 TODO

I should probably add a function to dispatch calls automatically, that way the
user doesn't have to explicity call a function to verify an option.  It would
make it very easy to write loops to validate input.

=head1 BUGS

This library was designed to validate ResponseGroup requests only.  Support for
other parameters were autogenerated but not verified.  The biggest problems are
with the intrepration of 'Integers 1 to 30', 'A Merchant ID', or 'Amazon (the
default value)'.

=head1 AUTHOR

Christopher Boumenot, E<lt>boumenot@gmail.comE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright 2006 by Christopher Boumenot E<lt>boumenot@gmail.comE<gt>

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself. 

=cut
