/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core;

import org.postgresql.core.ParameterList;

public class NativeQuery {
    private static final String[] BIND_NAMES = new String[128];
    private static final int[] NO_BINDS = new int[0];
    public final String nativeSql;
    public final int[] bindPositions;

    public NativeQuery(String nativeSql) {
        this(nativeSql, NO_BINDS);
    }

    public NativeQuery(String nativeSql, int[] bindPositions) {
        this.nativeSql = nativeSql;
        this.bindPositions = bindPositions == null || bindPositions.length == 0 ? NO_BINDS : bindPositions;
    }

    public String toString(ParameterList parameters) {
        if (this.bindPositions.length == 0) {
            return this.nativeSql;
        }
        int queryLength = this.nativeSql.length();
        String[] params = new String[this.bindPositions.length];
        for (int i2 = 1; i2 <= this.bindPositions.length; ++i2) {
            String param;
            params[i2 - 1] = param = parameters == null ? "?" : parameters.toString(i2);
            queryLength += param.length() - NativeQuery.bindName(i2).length();
        }
        StringBuilder sbuf = new StringBuilder(queryLength);
        sbuf.append(this.nativeSql, 0, this.bindPositions[0]);
        for (int i3 = 1; i3 <= this.bindPositions.length; ++i3) {
            sbuf.append(params[i3 - 1]);
            int nextBind = i3 < this.bindPositions.length ? this.bindPositions[i3] : this.nativeSql.length();
            sbuf.append(this.nativeSql, this.bindPositions[i3 - 1] + NativeQuery.bindName(i3).length(), nextBind);
        }
        return sbuf.toString();
    }

    public static String bindName(int index) {
        return index < BIND_NAMES.length ? BIND_NAMES[index] : "$" + index;
    }

    static {
        for (int i2 = 1; i2 < BIND_NAMES.length; ++i2) {
            NativeQuery.BIND_NAMES[i2] = "$" + i2;
        }
    }
}

