/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.utilities;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import sun.jvm.hotspot.code.CodeBlob;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.gc_interface.CollectedHeap;
import sun.jvm.hotspot.interpreter.InterpreterCodelet;
import sun.jvm.hotspot.memory.Generation;
import sun.jvm.hotspot.runtime.JNIHandleBlock;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.Thread;
import sun.jvm.hotspot.runtime.ThreadLocalAllocBuffer;
import sun.jvm.hotspot.utilities.Assert;

public class PointerLocation {
    Address addr;
    CollectedHeap heap;
    Generation gen;
    boolean inTLAB;
    JavaThread tlabThread;
    ThreadLocalAllocBuffer tlab;
    boolean inInterpreter;
    boolean inCodeCache;
    InterpreterCodelet interpreterCodelet;
    CodeBlob blob;
    boolean inBlobCode;
    boolean inBlobData;
    boolean inBlobOops;
    boolean inBlobUnknownLocation;
    boolean inStrongGlobalJNIHandleBlock;
    boolean inWeakGlobalJNIHandleBlock;
    boolean inLocalJNIHandleBlock;
    JNIHandleBlock handleBlock;
    Thread handleThread;

    public PointerLocation(Address addr) {
        this.addr = addr;
    }

    public boolean isInHeap() {
        return this.heap != null || this.gen != null;
    }

    public boolean isInNewGen() {
        return this.gen != null && this.gen.level() == 0;
    }

    public boolean isInOldGen() {
        return this.gen != null && this.gen.level() == 1;
    }

    public boolean inOtherGen() {
        return !this.isInNewGen() && !this.isInOldGen();
    }

    public Generation getGeneration() {
        return this.gen;
    }

    public boolean isInTLAB() {
        return this.inTLAB;
    }

    public JavaThread getTLABThread() {
        return this.tlabThread;
    }

    public ThreadLocalAllocBuffer getTLAB() {
        return this.tlab;
    }

    public boolean isInInterpreter() {
        return this.inInterpreter;
    }

    public InterpreterCodelet getInterpreterCodelet() {
        return this.interpreterCodelet;
    }

    public boolean isInCodeCache() {
        return this.inCodeCache;
    }

    public CodeBlob getCodeBlob() {
        return this.blob;
    }

    public boolean isInBlobCode() {
        return this.inBlobCode;
    }

    public boolean isInBlobData() {
        return this.inBlobData;
    }

    public boolean isInBlobOops() {
        return this.inBlobOops;
    }

    public boolean isInBlobUnknownLocation() {
        return this.inBlobUnknownLocation;
    }

    public boolean isInStrongGlobalJNIHandleBlock() {
        return this.inStrongGlobalJNIHandleBlock;
    }

    public boolean isInWeakGlobalJNIHandleBlock() {
        return this.inWeakGlobalJNIHandleBlock;
    }

    public boolean isInLocalJNIHandleBlock() {
        return this.inLocalJNIHandleBlock;
    }

    public JNIHandleBlock getJNIHandleBlock() {
        return this.handleBlock;
    }

    public Thread getJNIHandleThread() {
        return this.handleThread;
    }

    public boolean isUnknown() {
        return !this.isInHeap() && !this.isInInterpreter() && !this.isInCodeCache() && !this.isInStrongGlobalJNIHandleBlock() && !this.isInWeakGlobalJNIHandleBlock() && !this.isInLocalJNIHandleBlock();
    }

    public String toString() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.printOn(new PrintStream(bos));
        return bos.toString();
    }

    public void print() {
        this.printOn(System.out);
    }

    public void printOn(PrintStream tty) {
        tty.print("Address ");
        if (this.addr == null) {
            tty.print("0x0");
        } else {
            tty.print(this.addr.toString());
        }
        tty.print(": ");
        if (this.isInHeap()) {
            if (this.isInTLAB()) {
                tty.print("In thread-local allocation buffer for thread \"" + this.getTLABThread().getThreadName() + "\" (");
                this.getTLABThread().printThreadIDOn(tty);
                tty.print(") ");
                this.getTLAB().printOn(tty);
            } else {
                if (this.isInNewGen()) {
                    tty.print("In new generation ");
                } else if (this.isInOldGen()) {
                    tty.print("In old generation ");
                } else if (this.gen != null) {
                    tty.print("In Generation " + this.getGeneration().level());
                } else {
                    tty.print("In unknown section of Java heap");
                }
                if (this.getGeneration() != null) {
                    this.getGeneration().printOn(tty);
                }
            }
        } else if (this.isInInterpreter()) {
            tty.println("In interpreter codelet \"" + this.interpreterCodelet.getDescription() + "\"");
            this.interpreterCodelet.printOn(tty);
        } else if (this.isInCodeCache()) {
            CodeBlob b = this.getCodeBlob();
            tty.print("In ");
            if (this.isInBlobCode()) {
                tty.print("code");
            } else if (this.isInBlobData()) {
                tty.print("data");
            } else if (this.isInBlobOops()) {
                tty.print("oops");
            } else {
                if (Assert.ASSERTS_ENABLED) {
                    Assert.that(this.isInBlobUnknownLocation(), "Should have known location in CodeBlob");
                }
                tty.print("unknown location");
            }
            tty.print(" in ");
            b.printOn(tty);
        } else if (this.isInStrongGlobalJNIHandleBlock() || this.isInWeakGlobalJNIHandleBlock() || this.isInLocalJNIHandleBlock()) {
            tty.print("In ");
            if (this.isInStrongGlobalJNIHandleBlock()) {
                tty.print("strong global");
            } else if (this.isInWeakGlobalJNIHandleBlock()) {
                tty.print("weak global");
            } else {
                tty.print("thread-local");
            }
            tty.print(" JNI handle block (" + this.handleBlock.top() + " handle slots present)");
            if (this.isInLocalJNIHandleBlock()) {
                if (this.handleThread.isJavaThread()) {
                    tty.print(" for JavaThread ");
                    ((JavaThread)this.handleThread).printThreadIDOn(tty);
                } else {
                    tty.print("for a non-Java Thread");
                }
            }
        } else {
            if (Assert.ASSERTS_ENABLED) {
                Assert.that(this.isUnknown(), "Should have unknown location");
            }
            tty.print("In unknown location");
        }
    }
}

