/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.ci.ciEnv;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;

public class CompilerThread
extends JavaThread {
    private static AddressField _env_field;
    private ciEnv _env;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("CompilerThread");
        _env_field = type.getAddressField("_env");
    }

    public synchronized ciEnv env() {
        Address v;
        if (this._env == null && (v = _env_field.getValue(this.getAddress())) != null) {
            this._env = new ciEnv(v);
        }
        return this._env;
    }

    public CompilerThread(Address addr) {
        super(addr);
    }

    @Override
    public boolean isJavaThread() {
        return false;
    }

    @Override
    public boolean isHiddenFromExternalView() {
        return true;
    }

    @Override
    public boolean isCompilerThread() {
        return true;
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                CompilerThread.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

