/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.interpreter;

import sun.jvm.hotspot.interpreter.Bytecode;
import sun.jvm.hotspot.interpreter.BytecodeStream;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.utilities.Assert;

public class BytecodeTableswitch
extends Bytecode {
    BytecodeTableswitch(Method method, int bci) {
        super(method, bci);
    }

    public int defaultOffset() {
        return this.javaSignedWordAt(this.alignedOffset(1));
    }

    public int lowKey() {
        return this.javaSignedWordAt(this.alignedOffset(5));
    }

    public int highKey() {
        return this.javaSignedWordAt(this.alignedOffset(9));
    }

    public int length() {
        return this.highKey() - this.lowKey() + 1;
    }

    public int destOffsetAt(int i) {
        int x2 = this.alignedOffset(1 + (3 + i) * 4);
        int val = this.javaSignedWordAt(x2);
        return this.javaSignedWordAt(this.alignedOffset(1 + (3 + i) * 4));
    }

    public void verify() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.isValid(), "check tableswitch");
        }
    }

    public boolean isValid() {
        boolean result;
        boolean bl = result = this.javaCode() == 170;
        if (!result) {
            return false;
        }
        int lo = this.lowKey();
        int hi = this.highKey();
        if (hi < lo) {
            return false;
        }
        int i = hi - lo - 1;
        while (i-- > 0) {
        }
        return true;
    }

    public static BytecodeTableswitch at(Method method, int bci) {
        BytecodeTableswitch b = new BytecodeTableswitch(method, bci);
        if (Assert.ASSERTS_ENABLED) {
            b.verify();
        }
        return b;
    }

    public static BytecodeTableswitch atCheck(Method method, int bci) {
        BytecodeTableswitch b = new BytecodeTableswitch(method, bci);
        return b.isValid() ? b : null;
    }

    public static BytecodeTableswitch at(BytecodeStream bcs) {
        return new BytecodeTableswitch(bcs.method(), bcs.bci());
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("tableswitch");
        buf.append(" ");
        buf.append("default: ");
        buf.append(Integer.toString(this.bci() + this.defaultOffset()));
        buf.append(", ");
        int lo = this.lowKey();
        int hi = this.highKey();
        int i = hi - lo - 1;
        while (i-- > 0) {
            buf.append("case ");
            buf.append(Integer.toString(lo + i));
            buf.append(':');
            buf.append(Integer.toString(this.bci() + this.destOffsetAt(i)));
            buf.append(", ");
        }
        return buf.toString();
    }
}

