/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.ci;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.ci.ciKlass;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.memory.SystemDictionary;
import sun.jvm.hotspot.oops.BooleanField;
import sun.jvm.hotspot.oops.ByteField;
import sun.jvm.hotspot.oops.CIntField;
import sun.jvm.hotspot.oops.CharField;
import sun.jvm.hotspot.oops.ConstantPool;
import sun.jvm.hotspot.oops.DoubleField;
import sun.jvm.hotspot.oops.Field;
import sun.jvm.hotspot.oops.FloatField;
import sun.jvm.hotspot.oops.Instance;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.IntField;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.LongField;
import sun.jvm.hotspot.oops.ObjArray;
import sun.jvm.hotspot.oops.ObjArrayKlass;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.OopField;
import sun.jvm.hotspot.oops.OopUtilities;
import sun.jvm.hotspot.oops.ShortField;
import sun.jvm.hotspot.oops.TypeArray;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;

public class ciInstanceKlass
extends ciKlass {
    private static CIntField initStateField;
    private static CIntField isSharedField;
    private static int CLASS_STATE_LINKED;
    private static int CLASS_STATE_FULLY_INITIALIZED;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("ciInstanceKlass");
        initStateField = new CIntField(type.getCIntegerField("_init_state"), 0L);
        isSharedField = new CIntField(type.getCIntegerField("_is_shared"), 0L);
        CLASS_STATE_LINKED = db.lookupIntConstant("InstanceKlass::linked");
        CLASS_STATE_FULLY_INITIALIZED = db.lookupIntConstant("InstanceKlass::fully_initialized");
    }

    public ciInstanceKlass(Address addr) {
        super(addr);
    }

    public int initState() {
        int initState = (int)initStateField.getValue(this.getAddress());
        if (this.isShared() && initState < CLASS_STATE_LINKED) {
            InstanceKlass ik = (InstanceKlass)this.getMetadata();
            initState = ik.getInitStateAsInt();
        }
        return initState;
    }

    public boolean isShared() {
        return isSharedField.getValue(this.getAddress()) != 0L;
    }

    public boolean isLinked() {
        return this.initState() >= CLASS_STATE_LINKED;
    }

    public boolean isInitialized() {
        return this.initState() == CLASS_STATE_FULLY_INITIALIZED;
    }

    @Override
    public void dumpReplayData(PrintStream out) {
        InstanceKlass ik = (InstanceKlass)this.getMetadata();
        ConstantPool cp = ik.getConstants();
        for (Klass sub = ik.getSubklassKlass(); sub != null; sub = sub.getNextSiblingKlass()) {
            if (!(sub instanceof InstanceKlass)) continue;
            out.println("instanceKlass " + sub.getName().asString());
        }
        int length = cp.getLength();
        out.print("ciInstanceKlass " + this.name() + " " + (this.isLinked() ? 1 : 0) + " " + (this.isInitialized() ? 1 : 0) + " " + length);
        for (int index = 1; index < length; ++index) {
            out.print(" " + cp.getTags().at(index));
        }
        out.println();
        if (this.isInitialized()) {
            Field[] staticFields = ik.getStaticFields();
            for (int i = 0; i < staticFields.length; ++i) {
                Field bf;
                Field f = staticFields[i];
                Instance mirror = ik.getJavaMirror();
                if (!f.isFinal() || f.hasInitialValue()) continue;
                out.print("staticfield " + this.name() + " " + OopUtilities.escapeString(f.getID().getName()) + " " + f.getFieldType().getSignature().asString() + " ");
                if (f instanceof ByteField) {
                    bf = (ByteField)f;
                    out.println(((ByteField)bf).getValue(mirror));
                    continue;
                }
                if (f instanceof BooleanField) {
                    bf = (BooleanField)f;
                    out.println(((BooleanField)bf).getValue(mirror) ? 1 : 0);
                    continue;
                }
                if (f instanceof ShortField) {
                    bf = (ShortField)f;
                    out.println(((ShortField)bf).getValue(mirror));
                    continue;
                }
                if (f instanceof CharField) {
                    bf = (CharField)f;
                    out.println(((CharField)bf).getValue(mirror) & 0xFFFF);
                    continue;
                }
                if (f instanceof IntField) {
                    bf = (IntField)f;
                    out.println(((IntField)bf).getValue(mirror));
                    continue;
                }
                if (f instanceof LongField) {
                    bf = (LongField)f;
                    out.println(((LongField)bf).getValue(mirror));
                    continue;
                }
                if (f instanceof FloatField) {
                    bf = (FloatField)f;
                    out.println(Float.floatToRawIntBits(((FloatField)bf).getValue(mirror)));
                    continue;
                }
                if (f instanceof DoubleField) {
                    bf = (DoubleField)f;
                    out.println(Double.doubleToRawLongBits(((DoubleField)bf).getValue(mirror)));
                    continue;
                }
                if (!(f instanceof OopField)) continue;
                bf = (OopField)f;
                Oop value = ((OopField)bf).getValue(mirror);
                if (value == null) {
                    out.println("null");
                    continue;
                }
                if (value.isInstance()) {
                    Instance inst = (Instance)value;
                    if (inst.isA(SystemDictionary.getStringKlass())) {
                        out.println("\"" + OopUtilities.stringOopToEscapedString(inst) + "\"");
                        continue;
                    }
                    out.println(inst.getKlass().getName().asString());
                    continue;
                }
                if (value.isObjArray()) {
                    ObjArray oa = (ObjArray)value;
                    ObjArrayKlass ek = (ObjArrayKlass)oa.getKlass();
                    out.println(oa.getLength() + " " + ek.getName().asString());
                    continue;
                }
                if (value.isTypeArray()) {
                    TypeArray ta = (TypeArray)value;
                    out.println(ta.getLength());
                    continue;
                }
                out.println(value);
            }
        }
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                ciInstanceKlass.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

