/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import java.lang.management.MemoryNotificationInfo;
import java.lang.management.MemoryUsage;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import sun.management.LazyCompositeData;
import sun.management.MappedMXBeanType;
import sun.management.MemoryUsageCompositeData;

public class MemoryNotifInfoCompositeData
extends LazyCompositeData {
    private final MemoryNotificationInfo memoryNotifInfo;
    private static final CompositeType memoryNotifInfoCompositeType;
    private static final String POOL_NAME = "poolName";
    private static final String USAGE = "usage";
    private static final String COUNT = "count";
    private static final String[] memoryNotifInfoItemNames;
    private static final long serialVersionUID = -1805123446483771291L;

    private MemoryNotifInfoCompositeData(MemoryNotificationInfo memoryNotificationInfo) {
        this.memoryNotifInfo = memoryNotificationInfo;
    }

    public MemoryNotificationInfo getMemoryNotifInfo() {
        return this.memoryNotifInfo;
    }

    public static CompositeData toCompositeData(MemoryNotificationInfo memoryNotificationInfo) {
        MemoryNotifInfoCompositeData memoryNotifInfoCompositeData = new MemoryNotifInfoCompositeData(memoryNotificationInfo);
        return memoryNotifInfoCompositeData.getCompositeData();
    }

    @Override
    protected CompositeData getCompositeData() {
        Object[] objectArray = new Object[]{this.memoryNotifInfo.getPoolName(), MemoryUsageCompositeData.toCompositeData(this.memoryNotifInfo.getUsage()), new Long(this.memoryNotifInfo.getCount())};
        try {
            return new CompositeDataSupport(memoryNotifInfoCompositeType, memoryNotifInfoItemNames, objectArray);
        }
        catch (OpenDataException openDataException) {
            throw new AssertionError((Object)openDataException);
        }
    }

    public static String getPoolName(CompositeData compositeData) {
        String string = MemoryNotifInfoCompositeData.getString(compositeData, POOL_NAME);
        if (string == null) {
            throw new IllegalArgumentException("Invalid composite data: Attribute poolName has null value");
        }
        return string;
    }

    public static MemoryUsage getUsage(CompositeData compositeData) {
        CompositeData compositeData2 = (CompositeData)compositeData.get(USAGE);
        return MemoryUsage.from(compositeData2);
    }

    public static long getCount(CompositeData compositeData) {
        return MemoryNotifInfoCompositeData.getLong(compositeData, COUNT);
    }

    public static void validateCompositeData(CompositeData compositeData) {
        if (compositeData == null) {
            throw new NullPointerException("Null CompositeData");
        }
        if (!MemoryNotifInfoCompositeData.isTypeMatched(memoryNotifInfoCompositeType, compositeData.getCompositeType())) {
            throw new IllegalArgumentException("Unexpected composite type for MemoryNotificationInfo");
        }
    }

    static {
        try {
            memoryNotifInfoCompositeType = (CompositeType)MappedMXBeanType.toOpenType(MemoryNotificationInfo.class);
        }
        catch (OpenDataException openDataException) {
            throw new AssertionError((Object)openDataException);
        }
        memoryNotifInfoItemNames = new String[]{POOL_NAME, USAGE, COUNT};
    }
}

