/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.opengl;

import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.opengl.OGLContext;
import sun.java2d.opengl.OGLGraphicsConfig;
import sun.java2d.opengl.OGLRenderQueue;
import sun.java2d.opengl.OGLSurfaceData;
import sun.java2d.pipe.Region;

class OGLUtilities {
    public static final int UNDEFINED = 0;
    public static final int WINDOW = 1;
    public static final int TEXTURE = 3;
    public static final int FLIP_BACKBUFFER = 4;
    public static final int FBOBJECT = 5;

    private OGLUtilities() {
    }

    public static boolean isQueueFlusherThread() {
        return OGLRenderQueue.isQueueFlusherThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean invokeWithOGLContextCurrent(Graphics graphics, Runnable runnable) {
        OGLRenderQueue oGLRenderQueue = OGLRenderQueue.getInstance();
        oGLRenderQueue.lock();
        try {
            if (graphics != null) {
                if (!(graphics instanceof SunGraphics2D)) {
                    boolean bl = false;
                    return bl;
                }
                SurfaceData surfaceData = ((SunGraphics2D)graphics).surfaceData;
                if (!(surfaceData instanceof OGLSurfaceData)) {
                    boolean bl = false;
                    return bl;
                }
                OGLContext.validateContext((OGLSurfaceData)surfaceData);
            }
            oGLRenderQueue.flushAndInvokeNow(runnable);
            OGLContext.invalidateCurrentContext();
        }
        finally {
            oGLRenderQueue.unlock();
        }
        return true;
    }

    public static boolean invokeWithOGLSharedContextCurrent(GraphicsConfiguration graphicsConfiguration, Runnable runnable) {
        if (!(graphicsConfiguration instanceof OGLGraphicsConfig)) {
            return false;
        }
        OGLRenderQueue oGLRenderQueue = OGLRenderQueue.getInstance();
        oGLRenderQueue.lock();
        try {
            OGLContext.setScratchSurface((OGLGraphicsConfig)((Object)graphicsConfiguration));
            oGLRenderQueue.flushAndInvokeNow(runnable);
            OGLContext.invalidateCurrentContext();
        }
        finally {
            oGLRenderQueue.unlock();
        }
        return true;
    }

    public static Rectangle getOGLViewport(Graphics graphics, int n, int n2) {
        if (!(graphics instanceof SunGraphics2D)) {
            return null;
        }
        SunGraphics2D sunGraphics2D = (SunGraphics2D)graphics;
        SurfaceData surfaceData = sunGraphics2D.surfaceData;
        int n3 = sunGraphics2D.transX;
        int n4 = sunGraphics2D.transY;
        Rectangle rectangle = surfaceData.getBounds();
        int n5 = n3;
        int n6 = rectangle.height - (n4 + n2);
        return new Rectangle(n5, n6, n, n2);
    }

    public static Rectangle getOGLScissorBox(Graphics graphics) {
        if (!(graphics instanceof SunGraphics2D)) {
            return null;
        }
        SunGraphics2D sunGraphics2D = (SunGraphics2D)graphics;
        SurfaceData surfaceData = sunGraphics2D.surfaceData;
        Region region = sunGraphics2D.getCompClip();
        if (!region.isRectangular()) {
            return null;
        }
        int n = region.getLoX();
        int n2 = region.getLoY();
        int n3 = region.getWidth();
        int n4 = region.getHeight();
        Rectangle rectangle = surfaceData.getBounds();
        int n5 = n;
        int n6 = rectangle.height - (n2 + n4);
        return new Rectangle(n5, n6, n3, n4);
    }

    public static Object getOGLSurfaceIdentifier(Graphics graphics) {
        if (!(graphics instanceof SunGraphics2D)) {
            return null;
        }
        return ((SunGraphics2D)graphics).surfaceData;
    }

    public static int getOGLSurfaceType(Graphics graphics) {
        if (!(graphics instanceof SunGraphics2D)) {
            return 0;
        }
        SurfaceData surfaceData = ((SunGraphics2D)graphics).surfaceData;
        if (!(surfaceData instanceof OGLSurfaceData)) {
            return 0;
        }
        return ((OGLSurfaceData)surfaceData).getType();
    }

    public static int getOGLTextureType(Graphics graphics) {
        if (!(graphics instanceof SunGraphics2D)) {
            return 0;
        }
        SurfaceData surfaceData = ((SunGraphics2D)graphics).surfaceData;
        if (!(surfaceData instanceof OGLSurfaceData)) {
            return 0;
        }
        return ((OGLSurfaceData)surfaceData).getTextureTarget();
    }
}

