/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.SyncFailedException;
import java.util.ArrayList;
import java.util.List;
import sun.misc.JavaIOFileDescriptorAccess;
import sun.misc.SharedSecrets;

public final class FileDescriptor {
    private int fd;
    private Closeable parent;
    private List<Closeable> otherParents;
    private boolean closed;
    public static final FileDescriptor in = new FileDescriptor(0);
    public static final FileDescriptor out = new FileDescriptor(1);
    public static final FileDescriptor err = new FileDescriptor(2);

    public FileDescriptor() {
        this.fd = -1;
    }

    private FileDescriptor(int n) {
        this.fd = n;
    }

    public boolean valid() {
        return this.fd != -1;
    }

    public native void sync() throws SyncFailedException;

    private static native void initIDs();

    synchronized void attach(Closeable closeable) {
        if (this.parent == null) {
            this.parent = closeable;
        } else if (this.otherParents == null) {
            this.otherParents = new ArrayList<Closeable>();
            this.otherParents.add(this.parent);
            this.otherParents.add(closeable);
        } else {
            this.otherParents.add(closeable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void closeAll(Closeable closeable) throws IOException {
        block24: {
            if (!this.closed) {
                this.closed = true;
                IOException iOException = null;
                try (Closeable closeable2 = closeable;){
                    if (this.otherParents != null) {
                        for (Closeable closeable3 : this.otherParents) {
                            try {
                                closeable3.close();
                            }
                            catch (IOException iOException2) {
                                if (iOException == null) {
                                    iOException = iOException2;
                                    continue;
                                }
                                iOException.addSuppressed(iOException2);
                            }
                        }
                    }
                }
                catch (IOException iOException3) {
                    if (iOException != null) {
                        iOException3.addSuppressed(iOException);
                    }
                    iOException = iOException3;
                }
                finally {
                    if (iOException == null) break block24;
                    throw iOException;
                }
            }
        }
    }

    static {
        FileDescriptor.initIDs();
        SharedSecrets.setJavaIOFileDescriptorAccess(new JavaIOFileDescriptorAccess(){

            @Override
            public void set(FileDescriptor fileDescriptor, int n) {
                fileDescriptor.fd = n;
            }

            @Override
            public int get(FileDescriptor fileDescriptor) {
                return fileDescriptor.fd;
            }

            @Override
            public void setHandle(FileDescriptor fileDescriptor, long l) {
                throw new UnsupportedOperationException();
            }

            @Override
            public long getHandle(FileDescriptor fileDescriptor) {
                throw new UnsupportedOperationException();
            }
        });
    }
}

