/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocketFactory;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.SSLContextImpl;
import sun.security.ssl.SSLSocketImpl;

public final class SSLSocketFactoryImpl
extends SSLSocketFactory {
    private final SSLContextImpl context;

    public SSLSocketFactoryImpl() throws Exception {
        this.context = SSLContextImpl.DefaultSSLContext.getDefaultImpl();
    }

    SSLSocketFactoryImpl(SSLContextImpl sSLContextImpl) {
        this.context = sSLContextImpl;
    }

    @Override
    public Socket createSocket() {
        return new SSLSocketImpl(this.context);
    }

    @Override
    public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
        return new SSLSocketImpl(this.context, string, n);
    }

    @Override
    public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException {
        return new SSLSocketImpl(this.context, socket, string, n, bl);
    }

    @Override
    public Socket createSocket(Socket socket, InputStream inputStream, boolean bl) throws IOException {
        if (socket == null) {
            throw new NullPointerException("the existing socket cannot be null");
        }
        return new SSLSocketImpl(this.context, socket, inputStream, bl);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        return new SSLSocketImpl(this.context, inetAddress, n);
    }

    @Override
    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException {
        return new SSLSocketImpl(this.context, string, n, inetAddress, n2);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        return new SSLSocketImpl(this.context, inetAddress, n, inetAddress2, n2);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return CipherSuite.namesOf(this.context.getDefaultCipherSuites(false));
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return CipherSuite.namesOf(this.context.getSupportedCipherSuites());
    }
}

