/*-------------------------------------------------------------------------*/
/* Benchmark (Finite Domain)                                               */
/*                                                                         */
/* Name           : eq20.pl                                                */
/* Title          : linear equations                                       */
/* Original Source: Thomson LCR                                            */
/* Adapted by     : Daniel Diaz for GNU Prolog                             */
/* Date           : September 1992                                         */
/*                                                                         */
/* A system involving 7 variables and 20 equations                         */
/*                                                                         */
/* Solution:                                                               */
/*  [X1,X2,X3,X4,X5,X6,X7]                                                 */
/*  [ 1, 4, 6, 6, 6, 3, 1]                                                 */
/*-------------------------------------------------------------------------*/

q :-
	get_fd_labeling(Lab),
	statistics(runtime, _),
	eq20(LD, Lab),
	statistics(runtime, [_, Y]),
	write(LD),
	nl,
	write('time : '),
	write(Y),
	nl.




eq20(LD, Lab) :-
	LD = [X1, X2, X3, X4, X5, X6, X7],
	fd_domain(LD, 0, 10),
	876370 + 16105 * X1 + 6704 * X3 + 68610 * X6 #= 0 + 62397 * X2 + 43340 * X4 + 95100 * X5 + 58301 * X7,
	533909 + 96722 * X5 #= 0 + 51637 * X1 + 67761 * X2 + 95951 * X3 + 3834 * X4 + 59190 * X6 + 15280 * X7,
	915683 + 34121 * X2 + 33488 * X7 #= 0 + 1671 * X1 + 10763 * X3 + 80609 * X4 + 42532 * X5 + 93520 * X6,
	129768 + 11119 * X2 + 38875 * X4 + 14413 * X5 + 29234 * X6 #= 0 + 71202 * X1 + 73017 * X3 + 72370 * X7,
	752447 + 58412 * X2 #= 0 + 8874 * X1 + 73947 * X3 + 17147 * X4 + 62335 * X5 + 16005 * X6 + 8632 * X7,
	90614 + 18810 * X3 + 48219 * X4 + 79785 * X7 #= 0 + 85268 * X1 + 54180 * X2 + 6013 * X5 + 78169 * X6,
	1198280 + 45086 * X1 + 4578 * X3 #= 0 + 51830 * X2 + 96120 * X4 + 21231 * X5 + 97919 * X6 + 65651 * X7,
	18465 + 64919 * X1 + 59624 * X4 + 75542 * X5 + 47935 * X7 #= 0 + 80460 * X2 + 90840 * X3 + 25145 * X6,
	0 + 43525 * X2 + 92298 * X3 + 58630 * X4 + 92590 * X5 #= 1503588 + 43277 * X1 + 9372 * X6 + 60227 * X7,
	0 + 47385 * X2 + 97715 * X3 + 69028 * X5 + 76212 * X6 #= 1244857 + 16835 * X1 + 12640 * X4 + 81102 * X7,
	0 + 31227 * X2 + 93951 * X3 + 73889 * X4 + 81526 * X5 + 68026 * X7 #= 1410723 + 60301 * X1 + 72702 * X6,
	0 + 94016 * X1 + 35961 * X3 + 66597 * X4 #= 25334 + 82071 * X2 + 30705 * X5 + 44404 * X6 + 38304 * X7,
	0 + 84750 * X2 + 21239 * X4 + 81675 * X5 #= 277271 + 67456 * X1 + 51553 * X3 + 99395 * X6 + 4254 * X7,
	0 + 29958 * X2 + 57308 * X3 + 48789 * X4 + 4657 * X6 + 34539 * X7 #= 249912 + 85698 * X1 + 78219 * X5,
	0 + 85176 * X1 + 57898 * X4 + 15883 * X5 + 50547 * X6 + 83287 * X7 #= 373854 + 95332 * X2 + 1268 * X3,
	0 + 87758 * X2 + 19346 * X4 + 70072 * X5 + 44529 * X7 #= 740061 + 10343 * X1 + 11782 * X3 + 36991 * X6,
	0 + 49149 * X1 + 52871 * X2 + 56728 * X4 #= 146074 + 7132 * X3 + 33576 * X5 + 49530 * X6 + 62089 * X7,
	0 + 29475 * X2 + 34421 * X3 + 62646 * X5 + 29278 * X6 #= 251591 + 60113 * X1 + 76870 * X4 + 15212 * X7,
	22167 + 29101 * X2 + 5513 * X3 + 21219 * X4 #= 0 + 87059 * X1 + 22128 * X5 + 7276 * X6 + 57308 * X7,
	821228 + 76706 * X1 + 48614 * X6 + 41906 * X7 #= 0 + 98205 * X2 + 23445 * X3 + 67921 * X4 + 24111 * X5,
	lab(Lab, LD).




lab(normal, L) :-
	fd_labeling(L).

lab(ff, L) :-
	fd_labelingff(L).




get_fd_labeling(Lab) :-
	argument_counter(C),
	get_labeling1(C, Lab).


get_labeling1(1, normal).

get_labeling1(2, Lab) :-
	argument_value(1, Lab).




:-	initialization(q).
