/*
 * Copyright (c) 1996-1998
 *	John-Mark Gurney.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by John-Mark Gurney
 * 4. Neither the name of the author nor the names of any co-contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY John-Mark Gurney AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: cgi.h,v 1.16 1998/02/19 06:54:19 jmg Exp $
 */

#ifndef __CGI_H__
#define __CGI_H__ 1

#include <stdio.h>

const char *cgigetvalue(const char *a);	/* used to retrieve values, char * on
					   success, or NULL on error */

void cgiaddpair(char *name, char *valu);/* addes a name/value pair to list */
int cgireplace(char *name, char *value);/* replaces name's value with value */
void cginewquerystr(char *a);		/* uses user specified query str, for
					   testing purposes */

void cgiclose(void);			/* close cgi, frees ALL memory, clears
					   current name/value and stack */
void cgiclear(void);			/* clears cgi name/value pairs */
void cgiclearstack(void);		/* clears the stack of old states */

int cgidumpentry(FILE *, char **);	/* dumps out entries to file */
char **cgigetentry(FILE *a, char **b);	/* pass in list of fields */
void cgirecreate(char **fields, char **data);/* recreate name/value list from
					   cgi{dump,get}entry routines */
void cgifreeentry(char **a);

void cgipushcurrent(void);		/* pushes current name/value list */
int cgipopcurrent(void);		/* pops a name/value list */

int fhtmlheader(FILE *a);
int htmlheader(void);
int mail(char *from, char *to, char *subject, char *body);
int fcopyfile(FILE *out, const char *file);

#endif /* __CGI_H__ */
