# -*- coding: utf-8 -*-
# Copyright 2023 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

from __future__ import absolute_import, division, print_function


__metaclass__ = type

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the
# ansible.content_builder.
#
# Manually editing this file is not advised.
#
# To update the argspec make the desired changes
# in the documentation in the module file and re-run
# ansible.content_builder commenting out
# the path to external 'docstring' in build.yaml.
#
##############################################

"""
The arg spec for the iosxr_bgp_templates module
"""


class Bgp_templatesArgs(object):  # pylint: disable=R0903
    """The arg spec for the iosxr_bgp_templates module"""

    argument_spec = {
        "config": {
            "type": "dict",
            "options": {
                "as_number": {"type": "str"},
                "neighbor": {
                    "type": "list",
                    "elements": "dict",
                    "options": {
                        "name": {"type": "str"},
                        "address_family": {
                            "type": "list",
                            "elements": "dict",
                            "options": {
                                "afi": {
                                    "type": "str",
                                    "choices": ["ipv4", "ipv6"],
                                },
                                "safi": {
                                    "type": "str",
                                    "choices": [
                                        "flowspec",
                                        "mdt",
                                        "multicast",
                                        "mvpn",
                                        "rt-filter",
                                        "tunnel",
                                        "unicast",
                                        "labeled-unicast",
                                        "sr-policy",
                                    ],
                                },
                                "signalling": {
                                    "type": "dict",
                                    "options": {
                                        "bgp_disable": {"type": "bool"},
                                        "ldp_disable": {"type": "bool"},
                                    },
                                },
                                "advertise": {
                                    "type": "dict",
                                    "options": {
                                        "local_labeled_route": {
                                            "type": "dict",
                                            "options": {
                                                "set": {"type": "bool"},
                                                "disable": {"type": "bool"},
                                            },
                                        },
                                        "permanent_network": {"type": "bool"},
                                    },
                                },
                                "aigp": {
                                    "type": "dict",
                                    "options": {
                                        "disable": {"type": "bool"},
                                        "set": {"type": "bool"},
                                        "send_cost_community_disable": {
                                            "type": "bool",
                                        },
                                        "send_med": {
                                            "type": "dict",
                                            "options": {
                                                "set": {"type": "bool"},
                                                "disable": {"type": "bool"},
                                            },
                                        },
                                    },
                                },
                                "allowas_in": {
                                    "type": "dict",
                                    "options": {
                                        "value": {"type": "int"},
                                        "set": {"type": "bool"},
                                    },
                                },
                                "as_override": {
                                    "type": "dict",
                                    "options": {
                                        "set": {"type": "bool"},
                                        "inheritance_disable": {"type": "bool"},
                                    },
                                },
                                "bestpath_origin_as_allow_invalid": {
                                    "type": "bool",
                                },
                                "capability_orf_prefix": {
                                    "type": "str",
                                    "choices": ["both", "send", "none", "receive"],
                                },
                                "default_originate": {
                                    "type": "dict",
                                    "options": {
                                        "set": {"type": "bool"},
                                        "route_policy": {"type": "str"},
                                        "inheritance_disable": {"type": "bool"},
                                    },
                                },
                                "encapsulation_type_srv6": {"type": "bool"},
                                "long_lived_graceful_restart": {
                                    "type": "dict",
                                    "options": {
                                        "capable": {"type": "bool"},
                                        "stale_time": {
                                            "type": "dict",
                                            "options": {
                                                "send": {"type": "int"},
                                                "accept": {"type": "int"},
                                            },
                                        },
                                    },
                                },
                                "maximum_prefix": {
                                    "type": "dict",
                                    "options": {
                                        "max_limit": {"type": "int"},
                                        "threshold_value": {"type": "int"},
                                        "restart": {"type": "int"},
                                        "warning_only": {"type": "bool"},
                                        "discard_extra_paths": {"type": "bool"},
                                    },
                                },
                                "multipath": {"type": "bool"},
                                "next_hop_self": {
                                    "type": "dict",
                                    "options": {
                                        "set": {"type": "bool"},
                                        "inheritance_disable": {"type": "bool"},
                                    },
                                },
                                "next_hop_unchanged": {
                                    "type": "dict",
                                    "options": {
                                        "set": {"type": "bool"},
                                        "inheritance_disable": {"type": "bool"},
                                        "multipath": {"type": "bool"},
                                    },
                                },
                                "optimal_route_reflection_group_name": {
                                    "type": "str",
                                },
                                "orf_route_policy": {"type": "str"},
                                "origin_as": {
                                    "type": "dict",
                                    "options": {
                                        "validation": {
                                            "type": "dict",
                                            "options": {
                                                "disable": {"type": "bool"},
                                            },
                                        },
                                    },
                                },
                                "remove_private_AS": {
                                    "type": "dict",
                                    "options": {
                                        "set": {"type": "bool"},
                                        "inbound": {"type": "bool"},
                                        "entire_aspath": {"type": "bool"},
                                        "inheritance_disable": {"type": "bool"},
                                    },
                                },
                                "route_policy": {
                                    "type": "dict",
                                    "options": {
                                        "inbound": {"type": "str"},
                                        "outbound": {"type": "str"},
                                    },
                                },
                                "route_reflector_client": {
                                    "type": "dict",
                                    "options": {
                                        "set": {"type": "bool"},
                                        "inheritance_disable": {"type": "bool"},
                                    },
                                },
                                "send_community_ebgp": {
                                    "type": "dict",
                                    "options": {
                                        "set": {"type": "bool"},
                                        "inheritance_disable": {"type": "bool"},
                                    },
                                },
                                "send_community_gshut_ebgp": {
                                    "type": "dict",
                                    "options": {
                                        "set": {"type": "bool"},
                                        "inheritance_disable": {"type": "bool"},
                                    },
                                },
                                "send_extended_community_ebgp": {
                                    "type": "dict",
                                    "options": {
                                        "set": {"type": "bool"},
                                        "inheritance_disable": {"type": "bool"},
                                    },
                                },
                                "send_multicast_attributes": {
                                    "type": "dict",
                                    "options": {
                                        "set": {"type": "bool"},
                                        "disable": {"type": "bool"},
                                    },
                                },
                                "soft_reconfiguration": {
                                    "type": "dict",
                                    "options": {
                                        "inbound": {
                                            "type": "dict",
                                            "options": {
                                                "set": {"type": "bool"},
                                                "always": {"type": "bool"},
                                                "inheritance_disable": {
                                                    "type": "bool",
                                                },
                                            },
                                        },
                                    },
                                },
                                "weight": {"type": "int"},
                                "update": {
                                    "type": "dict",
                                    "options": {
                                        "out_originator_loopcheck_disable": {
                                            "type": "bool",
                                        },
                                        "out_originator_loopcheck_set": {
                                            "type": "bool",
                                        },
                                    },
                                },
                                "use": {"type": "str"},
                            },
                        },
                        "advertisement_interval": {"type": "int"},
                        "bfd": {
                            "type": "dict",
                            "options": {
                                "fast_detect": {
                                    "type": "dict",
                                    "options": {
                                        "set": {"type": "bool"},
                                        "disable": {"type": "bool"},
                                        "strict_mode": {"type": "bool"},
                                    },
                                },
                                "minimum_interval": {"type": "int"},
                                "multiplier": {"type": "int"},
                            },
                        },
                        "bmp_activate": {
                            "type": "dict",
                            "options": {"server": {"type": "int"}},
                        },
                        "capability": {
                            "type": "dict",
                            "options": {
                                "additional_paths": {
                                    "type": "dict",
                                    "options": {
                                        "send": {
                                            "type": "dict",
                                            "options": {
                                                "set": {"type": "bool"},
                                                "disable": {"type": "bool"},
                                            },
                                        },
                                        "receive": {
                                            "type": "dict",
                                            "options": {
                                                "set": {"type": "bool"},
                                                "disable": {"type": "bool"},
                                            },
                                        },
                                    },
                                },
                                "suppress": {
                                    "type": "dict",
                                    "options": {
                                        "four_byte_AS": {
                                            "type": "dict",
                                            "options": {"set": {"type": "bool"}},
                                        },
                                        "all": {
                                            "type": "dict",
                                            "options": {
                                                "inheritance_disable": {
                                                    "type": "bool",
                                                },
                                                "set": {"type": "bool"},
                                            },
                                        },
                                    },
                                },
                            },
                        },
                        "cluster_id": {"type": "str"},
                        "description": {"type": "str"},
                        "dmz_link_bandwidth": {
                            "type": "dict",
                            "options": {
                                "inheritance_disable": {"type": "bool"},
                                "set": {"type": "bool"},
                            },
                        },
                        "dscp": {"type": "str"},
                        "ebgp_multihop": {
                            "type": "dict",
                            "options": {
                                "value": {"type": "int"},
                                "mpls": {"type": "bool"},
                            },
                        },
                        "ebgp_recv_extcommunity_dmz": {
                            "type": "dict",
                            "options": {
                                "inheritance_disable": {"type": "bool"},
                                "set": {"type": "bool"},
                            },
                        },
                        "ebgp_send_extcommunity_dmz": {
                            "type": "dict",
                            "options": {
                                "inheritance_disable": {"type": "bool"},
                                "cumulatie": {"type": "bool"},
                                "set": {"type": "bool"},
                            },
                        },
                        "egress_engineering": {
                            "type": "dict",
                            "options": {
                                "inheritance_disable": {"type": "bool"},
                                "set": {"type": "bool"},
                            },
                        },
                        "enforce_first_as": {
                            "type": "dict",
                            "options": {"disable": {"type": "bool"}},
                        },
                        "graceful_maintenance": {
                            "type": "dict",
                            "options": {
                                "set": {"type": "bool"},
                                "activate": {
                                    "type": "dict",
                                    "options": {
                                        "inheritance_disable": {"type": "bool"},
                                        "set": {"type": "bool"},
                                    },
                                },
                                "as_prepends": {
                                    "type": "dict",
                                    "options": {
                                        "inheritance_disable": {"type": "bool"},
                                        "value": {"type": "int"},
                                    },
                                },
                                "local_preference": {
                                    "type": "dict",
                                    "options": {
                                        "value": {"type": "int"},
                                        "inheritance_disable": {"type": "bool"},
                                    },
                                },
                            },
                        },
                        "graceful_restart": {
                            "type": "dict",
                            "options": {
                                "restart_time": {"type": "int"},
                                "stalepath_time": {"type": "int"},
                            },
                        },
                        "ignore_connected_check": {
                            "type": "dict",
                            "options": {
                                "inheritance_disable": {"type": "bool"},
                                "set": {"type": "bool"},
                            },
                        },
                        "idle_watch_time": {"type": "int"},
                        "internal_vpn_client": {"type": "bool"},
                        "keychain": {
                            "type": "dict",
                            "no_log": False,
                            "options": {
                                "name": {"type": "str", "no_log": True},
                                "inheritance_disable": {"type": "bool"},
                            },
                        },
                        "local": {
                            "type": "dict",
                            "options": {
                                "address": {
                                    "type": "dict",
                                    "options": {
                                        "ipv4_address": {"type": "str"},
                                        "inheritance_disable": {"type": "bool"},
                                    },
                                },
                            },
                        },
                        "local_as": {
                            "type": "dict",
                            "options": {
                                "value": {"type": "int"},
                                "no_prepend": {
                                    "type": "dict",
                                    "options": {
                                        "set": {"type": "bool"},
                                        "replace_as": {
                                            "type": "dict",
                                            "options": {
                                                "set": {"type": "bool"},
                                                "dual_as": {"type": "bool"},
                                            },
                                        },
                                    },
                                },
                                "inheritance_disable": {"type": "bool"},
                            },
                        },
                        "local_address_subnet": {"type": "str"},
                        "log": {
                            "type": "dict",
                            "options": {
                                "log_message": {
                                    "type": "dict",
                                    "options": {
                                        "in": {
                                            "type": "dict",
                                            "options": {
                                                "value": {"type": "int"},
                                                "disable": {"type": "bool"},
                                                "inheritance_disable": {
                                                    "type": "bool",
                                                },
                                            },
                                        },
                                        "out": {
                                            "type": "dict",
                                            "options": {
                                                "value": {"type": "int"},
                                                "disable": {"type": "bool"},
                                                "inheritance_disable": {
                                                    "type": "bool",
                                                },
                                            },
                                        },
                                    },
                                },
                            },
                        },
                        "maximum_peers": {"type": "int"},
                        "password": {
                            "type": "dict",
                            "no_log": False,
                            "options": {
                                "encrypted": {"type": "str", "no_log": True},
                                "inheritance_disable": {"type": "bool"},
                            },
                        },
                        "peer_set": {"type": "int"},
                        "precedence": {
                            "type": "str",
                            "choices": [
                                "critical",
                                "flash",
                                "flash-override",
                                "immediate",
                                "internet",
                                "network",
                                "priority",
                                "routine",
                            ],
                        },
                        "receive_buffer_size": {"type": "int"},
                        "remote_as": {"type": "int"},
                        "remote_as_list": {"type": "str"},
                        "send_buffer_size": {"type": "int"},
                        "session_open_mode": {
                            "type": "str",
                            "choices": ["active-only", "both", "passive-only"],
                        },
                        "shutdown": {
                            "type": "dict",
                            "options": {
                                "inheritance_disable": {"type": "bool"},
                                "set": {"type": "bool"},
                            },
                        },
                        "tcp": {
                            "type": "dict",
                            "options": {
                                "mss": {
                                    "type": "dict",
                                    "options": {
                                        "value": {"type": "int"},
                                        "inheritance_disable": {"type": "bool"},
                                    },
                                },
                            },
                        },
                        "timers": {
                            "type": "dict",
                            "options": {
                                "keepalive_time": {"type": "int"},
                                "holdtime": {"type": "int"},
                                "min_holdtime": {"type": "int"},
                            },
                        },
                        "ttl_security": {
                            "type": "dict",
                            "options": {
                                "inheritance_disable": {"type": "bool"},
                                "set": {"type": "bool"},
                            },
                        },
                        "update": {
                            "type": "dict",
                            "options": {
                                "in": {
                                    "type": "dict",
                                    "options": {
                                        "filtering": {
                                            "type": "dict",
                                            "options": {
                                                "attribute_filter": {
                                                    "type": "dict",
                                                    "options": {
                                                        "group": {"type": "str"},
                                                    },
                                                },
                                                "logging": {
                                                    "type": "dict",
                                                    "options": {
                                                        "disable": {"type": "bool"},
                                                    },
                                                },
                                                "update_message": {
                                                    "type": "dict",
                                                    "options": {
                                                        "buffers": {"type": "int"},
                                                    },
                                                },
                                            },
                                        },
                                    },
                                },
                            },
                        },
                        "update_source": {"type": "str"},
                        "use": {
                            "type": "dict",
                            "options": {
                                "neighbor_group": {"type": "str"},
                                "session_group": {"type": "str"},
                            },
                        },
                    },
                },
            },
        },
        "running_config": {"type": "str"},
        "state": {
            "type": "str",
            "choices": [
                "deleted",
                "merged",
                "overridden",
                "replaced",
                "gathered",
                "rendered",
                "parsed",
            ],
            "default": "merged",
        },
    }  # pylint: disable=C0301
