/*
 * Decompiled with CFR 0.152.
 */
package tr.view.actions.screens.filters;

import ca.odell.glazedlists.matchers.Matcher;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import org.openide.util.NbBundle;
import tr.model.action.Action;
import tr.model.action.ActionStateDelegated;
import tr.swing.date.combo.DateItem;
import tr.util.DateUtils;
import tr.view.actions.screens.filters.FilterDate;
import tr.view.filters.FilterComboDate;

public class FilterDateFollowupTo
extends FilterDate
implements PropertyChangeListener {
    public static final byte INDEX = 19;
    private static final DateItem[] dateItems = new DateItem[]{DateItem.DATE_CHOOSER, DateItem.YESTERDAY, DateItem.TODAY, DateItem.TOMORROW, DateItem.WEEKS_1, DateItem.WEEKS_2, DateItem.WEEKS_3, DateItem.WEEKS_4};

    public FilterDateFollowupTo() {
        this.initialise();
    }

    protected void initialise() {
        this.combo = new FilterComboDate(dateItems, false);
        this.combo.addValueChangeListener((PropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent e) {
        DateItem item = (DateItem)this.combo.getSelectedItem();
        if (item == null) {
            this.fireMatchAll();
        } else {
            this.fireChanged(new ToDateMatcher(FilterComboDate.getDate((DateItem)item), this.excludeNulls));
        }
    }

    public String getLabel() {
        return NbBundle.getMessage(this.getClass(), (String)"filter-followup-to");
    }

    public byte getIndex() {
        return 19;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ToDateMatcher
    implements Matcher<Action> {
        private final Date matchDate;
        private final boolean excludeNulls;

        public ToDateMatcher(Date date, boolean excludeNulls) {
            this.matchDate = DateUtils.getEnd((Date)date);
            this.excludeNulls = excludeNulls;
        }

        public boolean matches(Action action) {
            if (this.matchDate == null) {
                return true;
            }
            if (!action.isStateDelegated()) {
                return false;
            }
            ActionStateDelegated state = (ActionStateDelegated)action.getState();
            Date date = state.getDate();
            if (date == null) {
                return !this.excludeNulls;
            }
            return !date.after(this.matchDate);
        }
    }
}

