/*
 * Decompiled with CFR 0.152.
 */
package tr.view;

import au.com.trgtd.tr.appl.InitialAction;
import au.com.trgtd.tr.appl.InitialActionLookup;
import java.util.Collection;
import java.util.logging.Logger;
import javax.swing.Action;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import tr.prefs.gui.GUIPrefs;

public class WindowUtils {
    private static final Logger LOG = Logger.getLogger("tr.viw");
    private static final TopComponent[] TC_ARRAY = new TopComponent[0];

    private WindowUtils() {
    }

    public static final void closeWindows() {
        TopComponent.Registry reg = WindowManager.getDefault().getRegistry();
        TopComponent[] tcs = reg.getOpened().toArray(TC_ARRAY);
        for (int i = 0; i < 10; ++i) {
            for (TopComponent tc : tcs) {
                tc.close();
            }
            tcs = reg.getOpened().toArray(TC_ARRAY);
            if (tcs.length != 0) continue;
            return;
        }
        LOG.severe("Windows probably not closed successfully.");
    }

    public static final void openInitialWindow() {
        String id = GUIPrefs.getInitialActionID();
        if (!id.equals("none")) {
            Lookup.Result r = InitialActionLookup.instance().lookup(new Lookup.Template(InitialAction.class));
            Collection c = r.allInstances();
            for (InitialAction action : c) {
                if (!action.getID().equals(id)) continue;
                ((Action)action).actionPerformed(null);
                return;
            }
        }
    }

    public static final void openOverviewWindow() {
        String id = "overview";
        Lookup.Result r = InitialActionLookup.instance().lookup(new Lookup.Template(InitialAction.class));
        Collection c = r.allInstances();
        for (InitialAction action : c) {
            if (!action.getID().equals(id)) continue;
            ((Action)action).actionPerformed(null);
            return;
        }
    }
}

