/*
 * Decompiled with CFR 0.152.
 */
package au.com.trgtd.tr.reports.actions.delegated;

import au.com.trgtd.tr.appl.Constants;
import au.com.trgtd.tr.reports.actions.delegated.Resources;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JRXmlDataSource;
import net.sf.jasperreports.view.JasperViewer;
import tr.extract.Extract;
import tr.extract.ExtractActions;
import tr.extract.Param;
import tr.extract.ParamBoolean;
import tr.extract.ParamDateList;
import tr.extract.ParamsDialog;
import tr.model.Data;
import tr.swing.date.combo.DateItem;
import tr.util.DateUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportImpl
extends Extract {
    private static final String ID = "tr.reports.actions.delegated";
    private static final DateFormat DF = Constants.DATE_FORMAT_FIXED;
    private ParamDateList paramDateFrom;
    private ParamDateList paramDateTo;
    private ParamBoolean paramGroup;
    private ParamBoolean paramSuccess;
    private ParamBoolean paramCriteria;
    private ParamBoolean paramProject;
    private ParamBoolean paramNotes;

    public String getID() {
        return ID;
    }

    public String getName() {
        return this.getString("CTL_ReportAction");
    }

    public List<Param> getParams() {
        Vector<Param> params = new Vector<Param>();
        this.paramGroup = new ParamBoolean("group", this.getString("param-group"));
        params.add((Param)this.paramGroup);
        Vector<DateItem> fromDateItems = new Vector<DateItem>();
        fromDateItems.add(DateItem.DATE_CHOOSER);
        fromDateItems.add(DateItem.TOMORROW);
        fromDateItems.add(DateItem.TODAY);
        fromDateItems.add(DateItem.YESTERDAY);
        fromDateItems.add(DateItem.WEEKS_AGO_1);
        fromDateItems.add(DateItem.WEEKS_AGO_2);
        fromDateItems.add(DateItem.WEEKS_AGO_3);
        fromDateItems.add(DateItem.WEEKS_AGO_4);
        this.paramDateFrom = new ParamDateList("from", this.getString("param-from"), fromDateItems);
        params.add((Param)this.paramDateFrom);
        Vector<DateItem> toDateItems = new Vector<DateItem>();
        toDateItems.add(DateItem.DATE_CHOOSER);
        toDateItems.add(DateItem.YESTERDAY);
        toDateItems.add(DateItem.TODAY);
        toDateItems.add(DateItem.TOMORROW);
        toDateItems.add(DateItem.WEEKS_1);
        toDateItems.add(DateItem.WEEKS_2);
        toDateItems.add(DateItem.WEEKS_3);
        toDateItems.add(DateItem.WEEKS_4);
        this.paramDateTo = new ParamDateList("to", this.getString("param-to"), toDateItems);
        params.add((Param)this.paramDateTo);
        this.paramCriteria = new ParamBoolean("paramCriteria", this.getString("param-criteria"));
        params.add((Param)this.paramCriteria);
        this.paramSuccess = new ParamBoolean("paramSuccess", this.getString("param-success"));
        params.add((Param)this.paramSuccess);
        this.paramProject = new ParamBoolean("paramProject", this.getString("param-project"));
        params.add((Param)this.paramProject);
        this.paramNotes = new ParamBoolean("paramNotes", this.getString("param-notes"));
        params.add((Param)this.paramNotes);
        return params;
    }

    public void process(Data data) throws Exception {
        Calendar c;
        String title = this.getDialogTitleReport(this.getName());
        ParamsDialog dlg = new ParamsDialog(title, this.getID(), this.getParams());
        if (dlg.showDialog() == 2) {
            return;
        }
        HashMap<String, Object> rparams = new HashMap<String, Object>();
        Date dateFrom = null;
        Date dateUpTo = null;
        long n = Long.parseLong(this.paramDateFrom.getValue());
        if (n < 1000L) {
            c = Calendar.getInstance();
            c.add(6, (int)n);
            dateFrom = c.getTime();
        } else {
            dateFrom = new Date(n);
        }
        n = Long.parseLong(this.paramDateTo.getValue());
        if (n < 1000L) {
            c = Calendar.getInstance();
            c.add(6, (int)n);
            dateUpTo = c.getTime();
        } else {
            dateUpTo = new Date(n);
        }
        if (DateUtils.isSameDay((Date)dateFrom, (Date)dateUpTo)) {
            rparams.put("paramDateRangeText", " For: " + DF.format(dateFrom));
        } else {
            rparams.put("paramDateRangeText", " From: " + DF.format(dateFrom) + "  To: " + DF.format(dateUpTo));
        }
        rparams.put("paramFrom", dateFrom.getTime());
        rparams.put("paramTo", dateUpTo.getTime());
        rparams.put("paramCriteria", Boolean.parseBoolean(this.paramCriteria.getValue()));
        rparams.put("paramSuccess", Boolean.parseBoolean(this.paramSuccess.getValue()));
        rparams.put("paramProject", Boolean.parseBoolean(this.paramProject.getValue()));
        rparams.put("paramNotes", Boolean.parseBoolean(this.paramNotes.getValue()));
        FileInputStream reportStream = this.paramGroup.getValue().equals("true") ? new FileInputStream(Resources.FILE_RPT_DELEGATED_GROUPED) : new FileInputStream(Resources.FILE_RPT_DELEGATED);
        File xmlfile = ReportImpl.getTmpFile((String)"Actions.xml");
        ExtractActions.process((Data)data, (File)xmlfile);
        JRXmlDataSource xmlDataSource = new JRXmlDataSource(xmlfile, "/data/actions/action");
        JasperPrint jasperPrint = JasperFillManager.fillReport((InputStream)reportStream, rparams, (JRDataSource)xmlDataSource);
        JasperViewer.viewReport((JasperPrint)jasperPrint, (boolean)false);
    }
}

