/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui.options.filetypes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.ui.options.filetypes.FileAssociationsModel;
import org.netbeans.core.ui.options.filetypes.NewExtensionPanel;
import org.netbeans.core.ui.options.filetypes.OpenAsPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public final class OpenAsAction
extends NodeAction {
    private static final Logger LOGGER = Logger.getLogger(OpenAsAction.class.getName());
    private OpenAsPanel openAsPanel;

    protected void performAction(Node[] nodeArray) {
        String string;
        if (this.openAsPanel == null) {
            this.openAsPanel = new OpenAsPanel();
        }
        FileAssociationsModel fileAssociationsModel = new FileAssociationsModel();
        this.openAsPanel.setModel(fileAssociationsModel);
        final DataObject dataObject = (DataObject)nodeArray[0].getLookup().lookup(DataObject.class);
        FileObject fileObject = dataObject.getPrimaryFile();
        String string2 = fileObject.getExt();
        this.openAsPanel.setExtension(string2);
        String string3 = NbBundle.getMessage(NewExtensionPanel.class, (String)"OpenAsPanel.open");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.openAsPanel, NbBundle.getMessage(OpenAsPanel.class, (String)"OpenAsPanel.title"), true, new Object[]{string3, DialogDescriptor.CANCEL_OPTION}, (Object)string3, 0, null, null);
        DialogDisplayer.getDefault().createDialog(dialogDescriptor).setVisible(true);
        if (string3.equals(dialogDescriptor.getValue()) && (string = this.openAsPanel.getMimeType()) != null) {
            dataObject.addPropertyChangeListener(new PropertyChangeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName().equals("valid") && !((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                        LOGGER.fine("PROP_VALID " + propertyChangeEvent.getNewValue() + " - " + propertyChangeEvent);
                        try {
                            OpenCookie openCookie = (OpenCookie)DataObject.find((FileObject)dataObject.getPrimaryFile()).getCookie(OpenCookie.class);
                            if (openCookie == null) return;
                            openCookie.open();
                            return;
                        }
                        catch (DataObjectNotFoundException dataObjectNotFoundException) {
                            LOGGER.log(Level.INFO, null, dataObjectNotFoundException);
                            return;
                        }
                        finally {
                            dataObject.removePropertyChangeListener((PropertyChangeListener)this);
                        }
                    } else {
                        dataObject.removePropertyChangeListener((PropertyChangeListener)this);
                    }
                }
            });
            fileAssociationsModel.setMimeType(string2, string);
            fileAssociationsModel.store();
            OpenCookie openCookie = (OpenCookie)dataObject.getCookie(OpenCookie.class);
            if (openCookie != null) {
                openCookie.open();
            }
        }
    }

    protected boolean asynchronous() {
        return false;
    }

    protected boolean enable(Node[] nodeArray) {
        return nodeArray != null && nodeArray.length == 1;
    }

    public String getName() {
        return NbBundle.getMessage(OpenAsAction.class, (String)"OpenAsAction.name");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(OpenAsAction.class);
    }
}

