/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.event;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.Block;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventAssembler;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BlockDeltasListEvent<E>
extends ListEvent<E> {
    private int blockCount;
    private Block currentBlock = null;
    private int rowIndex;
    private ListEventAssembler.BlockDeltasAssembler blocksAssembler;

    BlockDeltasListEvent(ListEventAssembler.BlockDeltasAssembler blocksAssembler, EventList<E> sourceList) {
        super(sourceList);
        this.blocksAssembler = blocksAssembler;
        this.blockCount = 0;
    }

    public BlockDeltasListEvent(BlockDeltasListEvent<E> original) {
        super(original.sourceList);
        this.blocksAssembler = original.blocksAssembler;
        this.blockCount = original.blockCount;
        this.currentBlock = original.currentBlock;
        this.rowIndex = original.rowIndex;
        this.sourceList = original.sourceList;
    }

    @Override
    public ListEvent copy() {
        return new BlockDeltasListEvent<E>(this);
    }

    @Override
    public void reset() {
        this.currentBlock = null;
        this.blockCount = 0;
    }

    @Override
    public boolean next() {
        if (this.currentBlock == null || this.rowIndex == this.getBlockEndIndex()) {
            return this.nextBlock();
        }
        if (this.rowIndex >= this.getBlockEndIndex()) {
            throw new IllegalStateException();
        }
        ++this.rowIndex;
        return true;
    }

    @Override
    public boolean hasNext() {
        if (this.currentBlock == null || this.rowIndex == this.getBlockEndIndex()) {
            return this.blockCount < this.getBlocks().size();
        }
        return true;
    }

    @Override
    public boolean nextBlock() {
        if (this.blockCount == this.getBlocks().size()) {
            this.currentBlock = null;
            this.rowIndex = -5;
            this.blockCount = 0;
            return false;
        }
        this.currentBlock = this.getBlocks().get(this.blockCount);
        ++this.blockCount;
        this.rowIndex = this.getBlockStartIndex();
        return true;
    }

    @Override
    public boolean isReordering() {
        return this.blocksAssembler.getReorderMap() != null;
    }

    @Override
    public int[] getReorderMap() {
        int[] reorderMap = this.blocksAssembler.getReorderMap();
        if (reorderMap == null) {
            throw new IllegalStateException("Cannot get reorder map for a non-reordering change");
        }
        return reorderMap;
    }

    @Override
    public int getIndex() {
        return this.getType() == 0 ? this.getBlockStartIndex() : this.rowIndex;
    }

    @Override
    public int getBlockStartIndex() {
        if (this.currentBlock == null) {
            throw new IllegalStateException();
        }
        return this.currentBlock.getStartIndex();
    }

    @Override
    public int getBlockEndIndex() {
        if (this.currentBlock == null) {
            throw new IllegalStateException();
        }
        return this.currentBlock.getEndIndex();
    }

    @Override
    public int getType() {
        if (this.currentBlock == null) {
            throw new IllegalStateException();
        }
        return this.currentBlock.getType();
    }

    @Override
    List<Block> getBlocks() {
        return this.blocksAssembler.getBlocks();
    }

    @Override
    public int getBlocksRemaining() {
        if (this.currentBlock != null && this.rowIndex < this.getBlockEndIndex()) {
            return this.getBlocks().size() - this.blockCount + 1;
        }
        return this.getBlocks().size() - this.blockCount;
    }

    @Override
    public String toString() {
        return "ListEvent: " + this.blocksAssembler.getBlocks();
    }
}

