/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.oasis;

import java.io.IOException;
import java.io.Writer;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.export.oasis.Style;

public class ParagraphStyle
extends Style {
    protected static final String HORIZONTAL_ALIGN_LEFT = "start";
    protected static final String HORIZONTAL_ALIGN_RIGHT = "end";
    protected static final String HORIZONTAL_ALIGN_CENTER = "center";
    protected static final String HORIZONTAL_ALIGN_JUSTIFY = "justified";
    private static final String VERTICAL_ALIGN_TOP = "top";
    private static final String VERTICAL_ALIGN_MIDDLE = "middle";
    private static final String VERTICAL_ALIGN_BOTTOM = "bottom";
    protected static final String ROTATION_ALIGN_NONE = "none";
    protected static final String ROTATION_ALIGN_TOP = "top";
    protected static final String ROTATION_ALIGN_CENTER = "center";
    protected static final String ROTATION_ALIGN_BOTTOM = "bottom";
    private String verticalAlignment = null;
    private String horizontalAlignment = null;
    private String runDirection = null;
    private String textRotation = "0";

    public ParagraphStyle(Writer styleWriter, JRPrintText text) {
        super(styleWriter);
        this.horizontalAlignment = ParagraphStyle.getHorizontalAlignment(text.getHorizontalAlignment(), text.getVerticalAlignment(), text.getRotation());
        this.verticalAlignment = ParagraphStyle.getVerticalAlignment(text.getHorizontalAlignment(), text.getVerticalAlignment(), text.getRotation());
        switch (text.getRotation()) {
            case 1: {
                this.textRotation = "90";
                break;
            }
            case 2: {
                this.textRotation = "270";
                break;
            }
            default: {
                this.textRotation = "0";
            }
        }
        this.runDirection = null;
        if (text.getRunDirection() == 1) {
            this.runDirection = "rl";
        }
    }

    public static String getVerticalAlignment(byte horizontalAlignment, byte verticalAlignment, byte rotation) {
        switch (rotation) {
            case 1: {
                switch (horizontalAlignment) {
                    case 3: {
                        return "top";
                    }
                    case 2: {
                        return VERTICAL_ALIGN_MIDDLE;
                    }
                    case 4: {
                        return HORIZONTAL_ALIGN_JUSTIFY;
                    }
                }
                return "bottom";
            }
            case 2: {
                switch (horizontalAlignment) {
                    case 3: {
                        return "bottom";
                    }
                    case 2: {
                        return VERTICAL_ALIGN_MIDDLE;
                    }
                    case 4: {
                        return HORIZONTAL_ALIGN_JUSTIFY;
                    }
                }
                return "top";
            }
        }
        switch (verticalAlignment) {
            case 3: {
                return "bottom";
            }
            case 2: {
                return VERTICAL_ALIGN_MIDDLE;
            }
        }
        return "top";
    }

    public static String getHorizontalAlignment(byte horizontalAlignment, byte verticalAlignment, byte rotation) {
        switch (rotation) {
            case 1: {
                switch (verticalAlignment) {
                    case 3: {
                        return HORIZONTAL_ALIGN_RIGHT;
                    }
                    case 2: {
                        return "center";
                    }
                }
                return HORIZONTAL_ALIGN_LEFT;
            }
            case 2: {
                switch (verticalAlignment) {
                    case 3: {
                        return HORIZONTAL_ALIGN_LEFT;
                    }
                    case 2: {
                        return "center";
                    }
                }
                return HORIZONTAL_ALIGN_RIGHT;
            }
        }
        switch (horizontalAlignment) {
            case 3: {
                return HORIZONTAL_ALIGN_RIGHT;
            }
            case 2: {
                return "center";
            }
            case 4: {
                return HORIZONTAL_ALIGN_JUSTIFY;
            }
        }
        return HORIZONTAL_ALIGN_LEFT;
    }

    public String getId() {
        return this.verticalAlignment + "|" + this.horizontalAlignment + "|" + this.runDirection + "|" + this.textRotation;
    }

    public void write(String paragraphStyleName) throws IOException {
        this.styleWriter.write("<style:style style:name=\"" + paragraphStyleName + "\"");
        this.styleWriter.write(" style:family=\"paragraph\">\n");
        this.styleWriter.write("<style:paragraph-properties");
        this.styleWriter.write(" fo:text-align=\"" + this.horizontalAlignment + "\"");
        this.styleWriter.write(" style:vertical-align=\"" + this.verticalAlignment + "\"");
        if (this.runDirection != null) {
            this.styleWriter.write(" style:writing-mode=\"" + this.runDirection + "\"");
        }
        this.styleWriter.write("> \r\n");
        this.styleWriter.write("</style:paragraph-properties>\n");
        this.styleWriter.write("<style:text-properties");
        this.styleWriter.write(" style:text-rotation-angle=\"" + this.textRotation + "\"");
        this.styleWriter.write("> \r\n");
        this.styleWriter.write("</style:text-properties>\n");
        this.styleWriter.write("</style:style>\n");
    }
}

