/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multiview;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Map;
import javax.swing.Action;
import org.netbeans.core.multiview.MultiViewElementCallbackDelegate;
import org.netbeans.core.multiview.MultiViewHandlerDelegate;
import org.netbeans.core.multiview.MultiViewModel;
import org.netbeans.core.multiview.MultiViewPeer;
import org.netbeans.core.multiview.SpiAccessor;
import org.netbeans.core.spi.multiview.CloseOperationHandler;
import org.netbeans.core.spi.multiview.MultiViewDescription;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.openide.awt.UndoRedo;
import org.openide.util.HelpCtx;
import org.openide.windows.TopComponent;

public final class MultiViewTopComponent
extends TopComponent
implements MultiViewModel.ActionRequestObserverFactory {
    MultiViewPeer peer = new MultiViewPeer(this, this);
    private Action[] superActions4Tests = null;

    public MultiViewTopComponent() {
        this.peer.initComponents();
        this.associateLookup(this.peer.getLookup());
        this.setName("");
        this.setFocusCycleRoot(false);
    }

    public void setMultiViewDescriptions(MultiViewDescription[] multiViewDescriptionArray, MultiViewDescription multiViewDescription) {
        this.peer.setMultiViewDescriptions(multiViewDescriptionArray, multiViewDescription);
    }

    public void setCloseOperationHandler(CloseOperationHandler closeOperationHandler) {
        this.peer.setCloseOperationHandler(closeOperationHandler);
    }

    private void setDeserializedMultiViewDescriptions(MultiViewDescription[] multiViewDescriptionArray, MultiViewDescription multiViewDescription, Map map) {
        this.peer.setDeserializedMultiViewDescriptions(multiViewDescriptionArray, multiViewDescription, map);
    }

    MultiViewModel getModel() {
        return this.peer.getModel();
    }

    protected void componentClosed() {
        super.componentClosed();
        this.peer.peerComponentClosed();
    }

    protected void componentShowing() {
        super.componentShowing();
        this.peer.peerComponentShowing();
    }

    protected void componentHidden() {
        super.componentHidden();
        this.peer.peerComponentHidden();
    }

    protected void componentDeactivated() {
        super.componentDeactivated();
        this.peer.peerComponentDeactivated();
    }

    protected void componentActivated() {
        super.componentActivated();
        this.peer.peerComponentActivated();
    }

    protected void componentOpened() {
        super.componentOpened();
        this.peer.peerComponentOpened();
    }

    public Action[] getActions() {
        Action[] actionArray = this.superActions4Tests == null ? super.getActions() : this.superActions4Tests;
        Action[] actionArray2 = this.peer.peerGetActions(actionArray);
        return actionArray2;
    }

    void setSuperActions(Action[] actionArray) {
        this.superActions4Tests = actionArray;
    }

    public MultiViewHandlerDelegate getMultiViewHandlerDelegate() {
        return this.peer.getMultiViewHandlerDelegate();
    }

    public int getPersistenceType() {
        return this.peer.getPersistenceType();
    }

    protected String preferredID() {
        return this.peer.preferredID();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        this.peer.peerWriteExternal(objectOutput);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.peer.peerReadExternal(objectInput);
    }

    Action[] getDefaultTCActions() {
        return super.getActions();
    }

    public MultiViewElementCallback createElementCallback(MultiViewDescription multiViewDescription) {
        return SpiAccessor.DEFAULT.createCallback(new ActReqObserver(multiViewDescription));
    }

    public HelpCtx getHelpCtx() {
        return this.peer.getHelpCtx();
    }

    public String toString() {
        return "MultiViewTopComponent[name=" + this.getDisplayName() + ", peer=" + this.peer + "]";
    }

    public UndoRedo getUndoRedo() {
        UndoRedo undoRedo = this.peer.peerGetUndoRedo();
        if (undoRedo == null) {
            undoRedo = super.getUndoRedo();
        }
        return undoRedo;
    }

    public boolean canClose() {
        return this.peer.canClose();
    }

    public boolean requestFocusInWindow() {
        return this.peer.requestFocusInWindow();
    }

    public void requestFocus() {
        this.peer.requestFocus();
    }

    class ActReqObserver
    implements Serializable,
    MultiViewElementCallbackDelegate {
        private static final long serialVersionUID = -3126744916624172415L;
        private MultiViewDescription description;

        ActReqObserver(MultiViewDescription multiViewDescription) {
            this.description = multiViewDescription;
        }

        public void requestActive() {
            boolean bl = MultiViewTopComponent.this.peer.isActivated();
            if (!bl) {
                MultiViewTopComponent.this.requestActive();
            }
            if (MultiViewTopComponent.this.peer.model.getActiveDescription() != this.description) {
                MultiViewTopComponent.this.peer.tabs.changeActiveManually(this.description);
                if (bl) {
                    MultiViewTopComponent.this.peer.model.getActiveElement().componentActivated();
                }
            }
        }

        public void requestVisible() {
            MultiViewTopComponent.this.peer.tabs.changeVisibleManually(this.description);
        }

        public Action[] createDefaultActions() {
            return MultiViewTopComponent.this.getDefaultTCActions();
        }

        public void updateTitle(String string) {
            MultiViewTopComponent.this.setDisplayName(string);
        }

        public Object writeReplace() throws ObjectStreamException {
            return null;
        }

        public Object readResolve() throws ObjectStreamException {
            return null;
        }

        public boolean isSelectedElement() {
            return this.description.equals(MultiViewTopComponent.this.peer.model.getActiveDescription());
        }

        public TopComponent getTopComponent() {
            return MultiViewTopComponent.this;
        }
    }
}

