/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.svg.AbstractElement;
import org.apache.batik.dom.svg.LiveAttributeValue;
import org.apache.batik.dom.svg.SVGContext;
import org.apache.batik.dom.svg.SVGOMAnimatedEnumeration;
import org.apache.batik.dom.svg.SVGOMAnimatedInteger;
import org.apache.batik.dom.svg.SVGOMAnimatedLength;
import org.apache.batik.dom.svg.SVGOMAnimatedNumber;
import org.apache.batik.dom.svg.SVGOMAnimatedString;
import org.apache.batik.dom.svg.SVGOMException;
import org.apache.batik.dom.svg.XMLBaseSupport;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGAnimatedEnumeration;
import org.w3c.dom.svg.SVGAnimatedInteger;
import org.w3c.dom.svg.SVGAnimatedLength;
import org.w3c.dom.svg.SVGAnimatedNumber;
import org.w3c.dom.svg.SVGAnimatedString;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGFitToViewBox;
import org.w3c.dom.svg.SVGSVGElement;

public abstract class SVGOMElement
extends AbstractElement
implements SVGElement,
SVGConstants {
    protected transient boolean readonly;
    protected String prefix;
    protected transient SVGContext svgContext;

    protected SVGOMElement() {
    }

    protected SVGOMElement(String string, AbstractDocument abstractDocument) {
        super(string, abstractDocument);
    }

    public String getId() {
        return this.getAttributeNS(null, "id");
    }

    public void setId(String string) {
        this.setAttributeNS(null, "id", string);
    }

    public String getXMLbase() {
        return XMLBaseSupport.getXMLBase(this);
    }

    public void setXMLbase(String string) throws DOMException {
        this.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:base", string);
    }

    public SVGSVGElement getOwnerSVGElement() {
        CSSStylableElement cSSStylableElement = CSSEngine.getParentCSSStylableElement(this);
        while (cSSStylableElement != null) {
            if (cSSStylableElement instanceof SVGSVGElement) {
                return (SVGSVGElement)((Object)cSSStylableElement);
            }
            cSSStylableElement = CSSEngine.getParentCSSStylableElement(cSSStylableElement);
        }
        return null;
    }

    public SVGElement getViewportElement() {
        CSSStylableElement cSSStylableElement = CSSEngine.getParentCSSStylableElement(this);
        while (cSSStylableElement != null) {
            if (cSSStylableElement instanceof SVGFitToViewBox) {
                return (SVGElement)((Object)cSSStylableElement);
            }
            cSSStylableElement = CSSEngine.getParentCSSStylableElement(cSSStylableElement);
        }
        return null;
    }

    public String getNodeName() {
        if (this.prefix == null || this.prefix.equals("")) {
            return this.getLocalName();
        }
        String string = this.getLocalName();
        StringBuffer stringBuffer = new StringBuffer(this.prefix.length() + string.length() + 1);
        stringBuffer.append(this.prefix).append(':').append(string);
        return stringBuffer.toString();
    }

    public String getNamespaceURI() {
        return "http://www.w3.org/2000/svg";
    }

    public void setPrefix(String string) throws DOMException {
        if (this.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
        }
        if (string != null && !string.equals("") && !DOMUtilities.isValidName(string)) {
            throw this.createDOMException((short)5, "prefix", new Object[]{new Integer(this.getNodeType()), this.getNodeName(), string});
        }
        this.prefix = string;
    }

    public void setSVGContext(SVGContext sVGContext) {
        this.svgContext = sVGContext;
    }

    public SVGContext getSVGContext() {
        return this.svgContext;
    }

    public SVGException createSVGException(short s, String string, Object[] objectArray) {
        try {
            return new SVGOMException(s, this.getCurrentDocument().formatMessage(string, objectArray));
        }
        catch (Exception exception) {
            return new SVGOMException(s, string);
        }
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean bl) {
        this.readonly = bl;
    }

    protected SVGAnimatedString getAnimatedStringAttribute(String string, String string2) {
        SVGAnimatedString sVGAnimatedString = (SVGAnimatedString)((Object)this.getLiveAttributeValue(string, string2));
        if (sVGAnimatedString == null) {
            sVGAnimatedString = new SVGOMAnimatedString(this, string, string2);
            this.putLiveAttributeValue(string, string2, (LiveAttributeValue)((Object)sVGAnimatedString));
        }
        return sVGAnimatedString;
    }

    protected SVGAnimatedNumber getAnimatedNumberAttribute(String string, String string2, float f) {
        SVGAnimatedNumber sVGAnimatedNumber = (SVGAnimatedNumber)((Object)this.getLiveAttributeValue(string, string2));
        if (sVGAnimatedNumber == null) {
            sVGAnimatedNumber = new SVGOMAnimatedNumber(this, string, string2, f);
            this.putLiveAttributeValue(string, string2, (LiveAttributeValue)((Object)sVGAnimatedNumber));
        }
        return sVGAnimatedNumber;
    }

    protected SVGAnimatedInteger getAnimatedIntegerAttribute(String string, String string2, int n) {
        SVGAnimatedInteger sVGAnimatedInteger = (SVGAnimatedInteger)((Object)this.getLiveAttributeValue(string, string2));
        if (sVGAnimatedInteger == null) {
            sVGAnimatedInteger = new SVGOMAnimatedInteger(this, string, string2, n);
            this.putLiveAttributeValue(string, string2, (LiveAttributeValue)((Object)sVGAnimatedInteger));
        }
        return sVGAnimatedInteger;
    }

    protected SVGAnimatedEnumeration getAnimatedEnumerationAttribute(String string, String string2, String[] stringArray, short s) {
        SVGAnimatedEnumeration sVGAnimatedEnumeration = (SVGAnimatedEnumeration)((Object)this.getLiveAttributeValue(string, string2));
        if (sVGAnimatedEnumeration == null) {
            sVGAnimatedEnumeration = new SVGOMAnimatedEnumeration(this, string, string2, stringArray, s);
            this.putLiveAttributeValue(string, string2, (LiveAttributeValue)((Object)sVGAnimatedEnumeration));
        }
        return sVGAnimatedEnumeration;
    }

    protected SVGAnimatedLength getAnimatedLengthAttribute(String string, String string2, String string3, short s) {
        SVGAnimatedLength sVGAnimatedLength = (SVGAnimatedLength)((Object)this.getLiveAttributeValue(string, string2));
        if (sVGAnimatedLength == null) {
            sVGAnimatedLength = new SVGOMAnimatedLength(this, string, string2, string3, s);
            this.putLiveAttributeValue(string, string2, (LiveAttributeValue)((Object)sVGAnimatedLength));
        }
        return sVGAnimatedLength;
    }

    protected Node export(Node node, AbstractDocument abstractDocument) {
        super.export(node, abstractDocument);
        SVGOMElement sVGOMElement = (SVGOMElement)node;
        sVGOMElement.prefix = this.prefix;
        return node;
    }

    protected Node deepExport(Node node, AbstractDocument abstractDocument) {
        super.deepExport(node, abstractDocument);
        SVGOMElement sVGOMElement = (SVGOMElement)node;
        sVGOMElement.prefix = this.prefix;
        return node;
    }

    protected Node copyInto(Node node) {
        super.copyInto(node);
        SVGOMElement sVGOMElement = (SVGOMElement)node;
        sVGOMElement.prefix = this.prefix;
        return node;
    }

    protected Node deepCopyInto(Node node) {
        super.deepCopyInto(node);
        SVGOMElement sVGOMElement = (SVGOMElement)node;
        sVGOMElement.prefix = this.prefix;
        return node;
    }
}

