/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.keymap;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import javax.swing.Action;
import org.netbeans.core.options.keymap.api.ShortcutAction;
import org.netbeans.core.options.keymap.spi.KeymapManager;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayersBridge
extends KeymapManager {
    static final String KEYMAPS_FOLDER = "Keymaps";
    private static final String SHORTCUTS_FOLDER = "Shortcuts";
    private static final String LAYERS_BRIDGE = "LayersBridge";
    private Map<GlobalAction, DataObject> actionToDataObject = new HashMap<GlobalAction, DataObject>();
    private Map<String, Set<ShortcutAction>> categoryToActions;
    private Set<GlobalAction> actions = new HashSet<GlobalAction>();
    private List<String> keymapNames;
    private Map<String, String> keymapDisplayNames;
    private Map<String, Map<ShortcutAction, Set<String>>> keymaps = new HashMap<String, Map<ShortcutAction, Set<String>>>();
    private Map<String, Map<ShortcutAction, Set<String>>> keymapDefaults = new HashMap<String, Map<ShortcutAction, Set<String>>>();

    public LayersBridge() {
        super(LAYERS_BRIDGE);
    }

    @Override
    public Map<String, Set<ShortcutAction>> getActions() {
        if (this.categoryToActions == null) {
            this.categoryToActions = new HashMap<String, Set<ShortcutAction>>();
            this.initActions("Actions", null);
            this.categoryToActions.remove("Hidden");
            this.categoryToActions = Collections.unmodifiableMap(this.categoryToActions);
        }
        return this.categoryToActions;
    }

    private void initActions(String string, String string2) {
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.findResource(string);
        if (fileObject == null) {
            return;
        }
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        Enumeration enumeration = dataFolder.children();
        while (enumeration.hasMoreElements()) {
            DataObject dataObject = (DataObject)enumeration.nextElement();
            if (!(dataObject instanceof DataFolder)) continue;
            this.initActions((DataFolder)dataObject, null, string2);
        }
    }

    private void initActions(DataFolder dataFolder, String string, String string2) {
        Object object;
        String string3 = dataFolder.getName();
        if (string2 != null) {
            string3 = string2;
        } else {
            object = (String)dataFolder.getPrimaryFile().getAttribute("SystemFileSystem.localizingBundle");
            if (object != null) {
                try {
                    string3 = NbBundle.getBundle((String)object).getString(dataFolder.getPrimaryFile().getPath());
                }
                catch (MissingResourceException missingResourceException) {
                    ErrorManager.getDefault().notify((Throwable)missingResourceException);
                }
            }
            if (string != null) {
                string3 = string + '/' + string3;
            }
        }
        object = dataFolder.children();
        while (object.hasMoreElements()) {
            DataObject dataObject = (DataObject)object.nextElement();
            if (dataObject instanceof DataFolder) {
                this.initActions((DataFolder)dataObject, string3, string2);
                continue;
            }
            GlobalAction globalAction = this.createAction(dataObject);
            if (this.actions.contains(globalAction) || globalAction == null) continue;
            this.actions.add(globalAction);
            Set<ShortcutAction> set = this.categoryToActions.get(string3);
            if (set == null) {
                set = new HashSet<ShortcutAction>();
                this.categoryToActions.put(string3, set);
            }
            set.add(globalAction);
            while (dataObject instanceof DataShadow) {
                dataObject = ((DataShadow)dataObject).getOriginal();
            }
            this.actionToDataObject.put(globalAction, dataObject);
        }
    }

    @Override
    public List<String> getProfiles() {
        if (this.keymapNames == null) {
            DataFolder dataFolder = LayersBridge.getRootFolder(KEYMAPS_FOLDER, null);
            Enumeration enumeration = dataFolder.children(false);
            this.keymapNames = new ArrayList<String>();
            this.keymapDisplayNames = new HashMap<String, String>();
            while (enumeration.hasMoreElements()) {
                String string;
                FileObject fileObject = ((DataObject)enumeration.nextElement()).getPrimaryFile();
                if (!fileObject.isFolder()) continue;
                String string2 = fileObject.getNameExt();
                try {
                    string = fileObject.getFileSystem().getStatus().annotateName(string2, Collections.singleton(fileObject));
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    string = string2;
                }
                this.keymapNames.add(string2);
                this.keymapDisplayNames.put(string2, string);
            }
            if (this.keymapNames.isEmpty()) {
                this.keymapNames.add("NetBeans");
            }
        }
        return Collections.unmodifiableList(this.keymapNames);
    }

    @Override
    public String getProfileDisplayName(String string) {
        String string2 = this.keymapDisplayNames.get(string);
        return string2 == null ? string : string2;
    }

    @Override
    public Map<ShortcutAction, Set<String>> getKeymap(String string) {
        if (!this.keymaps.containsKey(string)) {
            DataFolder dataFolder = LayersBridge.getRootFolder(SHORTCUTS_FOLDER, null);
            Map<ShortcutAction, Set<String>> map = this.readKeymap(dataFolder);
            dataFolder = LayersBridge.getRootFolder(KEYMAPS_FOLDER, string);
            map.putAll(this.readKeymap(dataFolder));
            this.keymaps.put(string, map);
        }
        return Collections.unmodifiableMap(this.keymaps.get(string));
    }

    @Override
    public Map<ShortcutAction, Set<String>> getDefaultKeymap(String string) {
        if (!this.keymapDefaults.containsKey(string)) {
            DataFolder dataFolder = LayersBridge.getRootFolder(SHORTCUTS_FOLDER, null);
            Map<ShortcutAction, Set<String>> map = this.readKeymap(dataFolder);
            dataFolder = LayersBridge.getRootFolder(KEYMAPS_FOLDER, string);
            map.putAll(this.readKeymap(dataFolder));
            this.keymapDefaults.put(string, map);
        }
        return Collections.unmodifiableMap(this.keymapDefaults.get(string));
    }

    DataObject getDataObject(Object object) {
        return this.actionToDataObject.get(object);
    }

    private Map<ShortcutAction, Set<String>> readKeymap(DataFolder dataFolder) {
        HashMap<ShortcutAction, Set<String>> hashMap = new HashMap<ShortcutAction, Set<String>>();
        if (dataFolder == null) {
            return hashMap;
        }
        Enumeration enumeration = dataFolder.children(false);
        while (enumeration.hasMoreElements()) {
            GlobalAction globalAction;
            DataObject dataObject = (DataObject)enumeration.nextElement();
            if (dataObject instanceof DataFolder || (globalAction = this.createAction(dataObject)) == null) continue;
            String string = dataObject.getName();
            HashSet<String> hashSet = (HashSet<String>)hashMap.get(globalAction);
            if (hashSet == null) {
                hashSet = new HashSet<String>();
                hashMap.put(globalAction, hashSet);
            }
            hashSet.add(string);
        }
        return hashMap;
    }

    @Override
    public void deleteProfile(String string) {
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().getRoot();
        if ((fileObject = fileObject.getFileObject(KEYMAPS_FOLDER)) == null) {
            return;
        }
        if ((fileObject = fileObject.getFileObject(string)) == null) {
            return;
        }
        try {
            fileObject.delete();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    @Override
    public void saveKeymap(String string, Map<ShortcutAction, Set<String>> map) {
        this.keymaps.remove(string);
        DataFolder dataFolder = LayersBridge.getRootFolder(KEYMAPS_FOLDER, string);
        if (dataFolder == null) {
            dataFolder = LayersBridge.getRootFolder(KEYMAPS_FOLDER, null);
            try {
                dataFolder = DataFolder.create((DataFolder)dataFolder, (String)string);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
                return;
            }
        }
        this.saveKeymap(dataFolder, map, true);
        dataFolder = LayersBridge.getRootFolder(SHORTCUTS_FOLDER, null);
        this.saveKeymap(dataFolder, map, false);
    }

    private void saveKeymap(DataFolder dataFolder, Map<ShortcutAction, Set<String>> map, boolean bl) {
        GlobalAction globalAction;
        this.getActions();
        Map<String, ShortcutAction> map2 = LayersBridge.shortcutToAction(map);
        Enumeration enumeration = dataFolder.children();
        while (enumeration.hasMoreElements()) {
            DataObject dataObject = (DataObject)enumeration.nextElement();
            GlobalAction object = (GlobalAction)map2.get(dataObject.getName());
            if (object != null) {
                globalAction = this.createAction(dataObject);
                if (globalAction == null) continue;
                if (globalAction.equals(object)) {
                    map2.remove(dataObject.getName());
                    continue;
                }
            }
            try {
                dataObject.delete();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (!bl) {
            return;
        }
        for (String string : map2.keySet()) {
            globalAction = (GlobalAction)map2.get(string);
            DataObject dataObject = this.actionToDataObject.get(globalAction);
            if (dataObject == null) {
                if (System.getProperty("org.netbeans.optionsDialog") == null) continue;
                System.out.println("No original DataObject specified! Not possible to create shadow1. " + globalAction);
                continue;
            }
            try {
                DataShadow.create((DataFolder)dataFolder, (String)string, (DataObject)dataObject);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private static DataFolder getRootFolder(String string, String string2) {
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().getRoot();
        FileObject fileObject2 = fileObject.getFileObject(string);
        try {
            if (fileObject2 == null) {
                fileObject2 = fileObject.createFolder(string);
            }
            if (fileObject2 == null) {
                return null;
            }
            if (string2 == null) {
                return DataFolder.findFolder((FileObject)fileObject2);
            }
            FileObject fileObject3 = fileObject2.getFileObject(string2);
            if (fileObject3 == null) {
                fileObject3 = fileObject2.createFolder(string2);
            }
            if (fileObject3 == null) {
                return null;
            }
            return DataFolder.findFolder((FileObject)fileObject3);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return null;
        }
    }

    private GlobalAction createAction(DataObject dataObject) {
        InstanceCookie instanceCookie = (InstanceCookie)dataObject.getCookie(InstanceCookie.class);
        if (instanceCookie == null) {
            return null;
        }
        try {
            Object object = instanceCookie.instanceCreate();
            if (object == null) {
                return null;
            }
            if (!(object instanceof Action)) {
                return null;
            }
            return new GlobalAction((Action)object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    static Map<String, ShortcutAction> shortcutToAction(Map<ShortcutAction, Set<String>> map) {
        HashMap<String, ShortcutAction> hashMap = new HashMap<String, ShortcutAction>();
        for (Map.Entry<ShortcutAction, Set<String>> entry : map.entrySet()) {
            ShortcutAction shortcutAction = entry.getKey();
            Set<String> set = entry.getValue();
            if (!((shortcutAction = shortcutAction.getKeymapManagerInstance(LAYERS_BRIDGE)) instanceof GlobalAction)) continue;
            for (String string : set) {
                hashMap.put(string, shortcutAction);
            }
        }
        return hashMap;
    }

    @Override
    public void refreshActions() {
    }

    @Override
    public String getCurrentProfile() {
        return null;
    }

    @Override
    public void setCurrentProfile(String string) {
    }

    @Override
    public boolean isCustomProfile(String string) {
        return false;
    }

    private static class GlobalAction
    implements ShortcutAction {
        private Action action;
        private String name;
        private String id;

        private GlobalAction(Action action) {
            this.action = action;
        }

        public String getDisplayName() {
            if (this.name == null) {
                this.name = (String)this.action.getValue("Name");
                if (this.name == null) {
                    this.name = this.action.toString();
                }
                this.name = this.name.replaceAll("&", "").trim();
            }
            return this.name;
        }

        public String getId() {
            if (this.id == null) {
                this.id = this.action.getClass().getName();
            }
            return this.id;
        }

        public String getDelegatingActionId() {
            return null;
        }

        public boolean equals(Object object) {
            if (!(object instanceof GlobalAction)) {
                return false;
            }
            return ((GlobalAction)object).action.equals(this.action);
        }

        public int hashCode() {
            return this.action.hashCode();
        }

        public String toString() {
            return "GlobalAction[" + this.getDisplayName() + ":" + this.id + "]";
        }

        public ShortcutAction getKeymapManagerInstance(String string) {
            if (LayersBridge.LAYERS_BRIDGE.equals(string)) {
                return this;
            }
            return null;
        }
    }
}

