/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.util;

import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.ValidationException;

public final class PropertyValidator {
    private static PropertyValidator instance = new PropertyValidator();

    private PropertyValidator() {
    }

    public void assertOneOrLess(String propertyName, PropertyList properties) throws ValidationException {
        if (properties.getProperties(propertyName).size() > 1) {
            throw new ValidationException("Property [" + propertyName + "] must only be specified once");
        }
    }

    public void assertOneOrMore(String propertyName, PropertyList properties) throws ValidationException {
        if (properties.getProperties(propertyName).size() < 1) {
            throw new ValidationException("Property [" + propertyName + "] must be specified at least once");
        }
    }

    public void assertOne(String propertyName, PropertyList properties) throws ValidationException {
        if (properties.getProperties(propertyName).size() != 1) {
            throw new ValidationException("Property [" + propertyName + "] must be specified once");
        }
    }

    public void assertNone(String propertyName, PropertyList properties) throws ValidationException {
        if (properties.getProperty(propertyName) != null) {
            throw new ValidationException("Property [" + propertyName + "] is not applicable");
        }
    }

    public static PropertyValidator getInstance() {
        return instance;
    }
}

