/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.validator;

import com.sun.xml.bind.validator.Messages;
import com.sun.xml.bind.validator.ValidatableObject;
import com.sun.xml.bind.validator.ValidationContext;
import javax.xml.bind.PropertyException;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationException;
import javax.xml.bind.Validator;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import org.xml.sax.SAXException;

public class ValidatorImpl
implements Validator {
    private ValidationEventHandler eventHandler = new DefaultValidationEventHandler();

    public boolean validateRoot(Object o) throws ValidationException {
        if (o == null) {
            throw new IllegalArgumentException(Messages.format("Shared.MustNotBeNull", "rootObj"));
        }
        return this.validate(o, true);
    }

    public boolean validate(Object o) throws ValidationException {
        if (o == null) {
            throw new IllegalArgumentException(Messages.format("Shared.MustNotBeNull", "subrootObj"));
        }
        return this.validate(o, false);
    }

    private boolean validate(Object o, boolean validateId) throws ValidationException {
        try {
            if (!(o instanceof ValidatableObject)) {
                throw new ValidationException(Messages.format("Validator.NotValidatable"));
            }
            ValidatableObject vo = (ValidatableObject)o;
            EventInterceptor ei = new EventInterceptor(this.eventHandler);
            ValidationContext context = new ValidationContext(ei, validateId);
            context.validate(vo);
            context.reconcileIDs();
            return !ei.hadError();
        }
        catch (SAXException e) {
            Exception nested = e.getException();
            if (e != null) {
                throw new ValidationException((Throwable)nested);
            }
            throw new ValidationException((Throwable)e);
        }
    }

    public ValidationEventHandler getEventHandler() {
        return this.eventHandler;
    }

    public void setEventHandler(ValidationEventHandler handler) {
        this.eventHandler = handler == null ? new DefaultValidationEventHandler() : handler;
    }

    public void setProperty(String name, Object value) throws PropertyException {
        if (name == null) {
            throw new IllegalArgumentException(Messages.format("Shared.MustNotBeNull", "name"));
        }
        throw new PropertyException(name, value);
    }

    public Object getProperty(String name) throws PropertyException {
        if (name == null) {
            throw new IllegalArgumentException(Messages.format("Shared.MustNotBeNull", "name"));
        }
        throw new PropertyException(name);
    }

    private static class EventInterceptor
    implements ValidationEventHandler {
        private boolean hadError = false;
        private final ValidationEventHandler next;

        EventInterceptor(ValidationEventHandler _next) {
            this.next = _next;
        }

        public boolean hadError() {
            return this.hadError;
        }

        public boolean handleEvent(ValidationEvent e) {
            boolean result;
            this.hadError = true;
            if (this.next != null) {
                try {
                    result = this.next.handleEvent(e);
                }
                catch (RuntimeException re) {
                    result = false;
                }
            } else {
                result = false;
            }
            return result;
        }
    }
}

