/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.actions;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.TopComponent;

public class LogViewerSupport
implements Runnable {
    boolean shouldStop = false;
    FileInputStream filestream = null;
    BufferedReader ins;
    InputOutput io;
    File fileName;
    String ioName;
    int lines;
    Ring ring;
    private final RequestProcessor.Task task = RequestProcessor.getDefault().create((Runnable)this);

    public LogViewerSupport(File file, String string) {
        this.fileName = file;
        this.ioName = string;
    }

    private void init() {
        this.ring = new Ring(2000);
        try {
            String string;
            while ((string = this.ins.readLine()) != null) {
                this.ring.add(string);
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(LogViewerSupport.class.getName()).log(Level.INFO, null, iOException);
        }
        this.lines = this.ring.output();
        this.ring.setMaxCount(2000);
    }

    public void run() {
        if (this.io.isClosed()) {
            this.shouldStop = true;
        } else {
            this.shouldStop = true;
            TopComponent.Registry registry = TopComponent.getRegistry();
            for (TopComponent topComponent : registry.getOpened()) {
                if (!topComponent.toString().startsWith("org.netbeans.core.output2.OutputWindow")) continue;
                this.shouldStop = false;
                break;
            }
        }
        if (!this.shouldStop) {
            try {
                String string;
                if (this.lines >= 10000) {
                    this.io.getOut().reset();
                    this.lines = this.ring.output();
                }
                while ((string = this.ins.readLine()) != null) {
                    if ((string = this.ring.add(string)) == null) continue;
                    this.io.getOut().println(string);
                    ++this.lines;
                }
            }
            catch (IOException iOException) {
                Logger.getLogger(LogViewerSupport.class.getName()).log(Level.INFO, null, iOException);
            }
            this.task.schedule(10000);
        } else {
            this.stopUpdatingLogViewer();
        }
    }

    public void showLogViewer() throws IOException {
        this.shouldStop = false;
        this.io = IOProvider.getDefault().getIO(this.ioName, false);
        this.io.getOut().reset();
        this.io.select();
        this.filestream = new FileInputStream(this.fileName);
        this.ins = new BufferedReader(new InputStreamReader(this.filestream));
        this.init();
        this.task.schedule(0);
    }

    public void stopUpdatingLogViewer() {
        try {
            this.ins.close();
            this.filestream.close();
            this.io.closeInputOutput();
            this.io.setOutputVisible(false);
        }
        catch (IOException iOException) {
            Logger.getLogger(LogViewerSupport.class.getName()).log(Level.INFO, null, iOException);
        }
    }

    private class Ring {
        private int maxCount;
        private int count;
        private LinkedList<String> anchor;

        public Ring(int n) {
            this.maxCount = n;
            this.count = 0;
            this.anchor = new LinkedList();
        }

        public String add(String string) {
            if (string == null || string.equals("")) {
                return null;
            }
            while (this.count >= this.maxCount) {
                this.anchor.removeFirst();
                --this.count;
            }
            this.anchor.addLast(string);
            ++this.count;
            return string;
        }

        public void setMaxCount(int n) {
            this.maxCount = n;
        }

        public int output() {
            int n = 0;
            for (String string : this.anchor) {
                LogViewerSupport.this.io.getOut().println(string);
                ++n;
            }
            return n;
        }

        public void reset() {
            this.anchor = new LinkedList();
        }
    }
}

