/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.tcp;

import java.util.HashSet;
import java.util.Set;
import org.jivesoftware.smack.c2s.ModularXmppClientToServerConnectionConfiguration;
import org.jivesoftware.smack.c2s.ModularXmppClientToServerConnectionModuleDescriptor;
import org.jivesoftware.smack.c2s.internal.ModularXmppClientToServerConnectionInternal;
import org.jivesoftware.smack.fsm.StateDescriptor;
import org.jivesoftware.smack.tcp.XmppTcpTransportModule;

public class XmppTcpTransportModuleDescriptor
extends ModularXmppClientToServerConnectionModuleDescriptor {
    private final boolean startTls;
    private final boolean directTls;

    public XmppTcpTransportModuleDescriptor(Builder builder) {
        this.startTls = builder.startTls;
        this.directTls = builder.directTls;
    }

    @Override
    protected Set<Class<? extends StateDescriptor>> getStateDescriptors() {
        HashSet<Class<? extends StateDescriptor>> res = new HashSet<Class<? extends StateDescriptor>>();
        res.add(XmppTcpTransportModule.EstablishingTcpConnectionStateDescriptor.class);
        if (this.startTls) {
            res.add(XmppTcpTransportModule.EstablishTlsStateDescriptor.class);
        }
        if (this.directTls) {
            throw new IllegalArgumentException("DirectTLS is not implemented yet");
        }
        return res;
    }

    protected XmppTcpTransportModule constructXmppConnectionModule(ModularXmppClientToServerConnectionInternal connectionInternal) {
        return new XmppTcpTransportModule(this, connectionInternal);
    }

    public boolean isStartTlsEnabled() {
        return this.startTls;
    }

    public boolean isDirectTlsEnabled() {
        return this.directTls;
    }

    public static final class Builder
    extends ModularXmppClientToServerConnectionModuleDescriptor.Builder {
        private boolean startTls = true;
        private boolean directTls = false;

        private Builder(ModularXmppClientToServerConnectionConfiguration.Builder connectionConfigurationBuilder) {
            super(connectionConfigurationBuilder);
        }

        public Builder disableDirectTls() {
            this.directTls = false;
            return this;
        }

        public Builder disableStartTls() {
            this.startTls = false;
            return this;
        }

        @Override
        protected XmppTcpTransportModuleDescriptor build() {
            return new XmppTcpTransportModuleDescriptor(this);
        }
    }
}

