/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.xmpp;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.jicofo.ConferenceStore;
import org.jitsi.jicofo.conference.JitsiMeetConference;
import org.jitsi.jicofo.xmpp.AbstractIqHandler;
import org.jitsi.jicofo.xmpp.IqProcessingResult;
import org.jitsi.jicofo.xmpp.IqRequest;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.xmpp.extensions.jibri.JibriIq;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.StanzaError;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lorg/jitsi/jicofo/xmpp/JibriIqHandler;", "Lorg/jitsi/jicofo/xmpp/AbstractIqHandler;", "Lorg/jitsi/xmpp/extensions/jibri/JibriIq;", "connections", "", "Lorg/jivesoftware/smack/AbstractXMPPConnection;", "conferenceStore", "Lorg/jitsi/jicofo/ConferenceStore;", "(Ljava/util/Set;Lorg/jitsi/jicofo/ConferenceStore;)V", "logger", "Lorg/jitsi/utils/logging2/Logger;", "getLogger", "()Lorg/jitsi/utils/logging2/Logger;", "handleRequest", "Lorg/jitsi/jicofo/xmpp/IqProcessingResult;", "request", "Lorg/jitsi/jicofo/xmpp/IqRequest;", "jicofo"})
public final class JibriIqHandler
extends AbstractIqHandler<JibriIq> {
    @NotNull
    private final ConferenceStore conferenceStore;
    @NotNull
    private final Logger logger;

    public JibriIqHandler(@NotNull Set<? extends AbstractXMPPConnection> connections, @NotNull ConferenceStore conferenceStore) {
        Intrinsics.checkNotNullParameter(connections, "connections");
        Intrinsics.checkNotNullParameter(conferenceStore, "conferenceStore");
        super(connections, "jibri", "http://jitsi.org/protocol/jibri", SetsKt.setOf(IQ.Type.set), IQRequestHandler.Mode.sync);
        this.conferenceStore = conferenceStore;
        this.logger = LoggerExtensionsKt.createLogger$default(this, null, null, 3, null);
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @Override
    @NotNull
    public IqProcessingResult handleRequest(@NotNull IqRequest<JibriIq> request) {
        Intrinsics.checkNotNullParameter(request, "request");
        Iterable $this$forEach$iv = this.conferenceStore.getAllConferences();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IqProcessingResult result2;
            JitsiMeetConference conference = (JitsiMeetConference)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(conference.handleJibriRequest(request), "conference.handleJibriRequest(request)");
            if (!((result2 instanceof IqProcessingResult.AcceptedWithResponse ? true : result2 instanceof IqProcessingResult.AcceptedWithNoResponse) ? true : result2 instanceof IqProcessingResult.RejectedWithError)) continue;
            return result2;
        }
        this.logger.warn("Jibri IQ not accepted by any conference: " + request.getIq().toXML());
        return new IqProcessingResult.RejectedWithError(request, StanzaError.Condition.item_not_found);
    }
}

