/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.bridge;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.jicofo.bridge.Bridge;
import org.jitsi.jicofo.bridge.BridgeSelectionStrategy;
import org.jitsi.jicofo.bridge.ConferenceBridgeProperties;
import org.jitsi.jicofo.bridge.ParticipantProperties;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u0004\u0018\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jitsi/jicofo/bridge/IntraRegionBridgeSelectionStrategy;", "Lorg/jitsi/jicofo/bridge/BridgeSelectionStrategy;", "()V", "doSelect", "Lorg/jitsi/jicofo/bridge/Bridge;", "bridges", "", "conferenceBridges", "", "Lorg/jitsi/jicofo/bridge/ConferenceBridgeProperties;", "participantProperties", "Lorg/jitsi/jicofo/bridge/ParticipantProperties;", "jicofo-selector"})
public final class IntraRegionBridgeSelectionStrategy
extends BridgeSelectionStrategy {
    @Override
    @Nullable
    public Bridge doSelect(@NotNull List<Bridge> bridges, @NotNull Map<Bridge, ConferenceBridgeProperties> conferenceBridges, @NotNull ParticipantProperties participantProperties) {
        Intrinsics.checkNotNullParameter(bridges, "bridges");
        Intrinsics.checkNotNullParameter(conferenceBridges, "conferenceBridges");
        Intrinsics.checkNotNullParameter(participantProperties, "participantProperties");
        String participantRegion = participantProperties.getRegion();
        if (bridges.isEmpty()) {
            return null;
        }
        if (conferenceBridges.isEmpty()) {
            Bridge bridge2 = this.notLoadedInRegion(bridges, conferenceBridges, participantProperties, participantRegion);
            if (bridge2 == null) {
                bridge2 = this.leastLoaded(bridges, conferenceBridges, participantProperties);
            }
            return bridge2;
        }
        String conferenceRegion = ((Bridge)CollectionsKt.first((Iterable)conferenceBridges.keySet())).getRegion();
        Bridge bridge3 = this.notLoadedAlreadyInConferenceInRegion(bridges, conferenceBridges, participantProperties, conferenceRegion);
        if (bridge3 == null && (bridge3 = this.notLoadedInRegion(bridges, conferenceBridges, participantProperties, conferenceRegion)) == null) {
            bridge3 = this.leastLoadedAlreadyInConferenceInRegion(bridges, conferenceBridges, participantProperties, conferenceRegion);
        }
        return bridge3;
    }
}

