/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal;

import jakarta.ws.rs.core.Configuration;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.internal.util.PropertiesHelper;

public interface PropertiesResolver {
    public <T> T resolveProperty(String var1, Class<T> var2);

    public <T> T resolveProperty(String var1, T var2);

    public static PropertiesResolver create(final Configuration configuration, final PropertiesDelegate delegate) {
        return new PropertiesResolver(){

            @Override
            public <T> T resolveProperty(String name, Class<T> type2) {
                return this.resolveProperty(name, null, type2);
            }

            @Override
            public <T> T resolveProperty(String name, T defaultValue) {
                return (T)this.resolveProperty(name, defaultValue, defaultValue.getClass());
            }

            private <T> T resolveProperty(String name, Object defaultValue, Class<T> type2) {
                Object result2 = configuration.getProperty(name);
                if (result2 != null) {
                    defaultValue = result2;
                }
                if ((result2 = delegate.getProperty(name)) == null) {
                    result2 = defaultValue;
                }
                return result2 == null ? null : (T)PropertiesHelper.convertValue(result2, type2);
            }
        };
    }
}

