/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.NotFoundClasses;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.Flags;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.constants.AnnotationValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ArrayValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.BooleanValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ByteValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.CharValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.DoubleValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.EnumValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ErrorValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.FloatValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.IntValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.KClassValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.LongValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ShortValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.StringValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.UByteValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.UIntValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ULongValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.UShortValue;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializedArrayValue;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolverUtilKt;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import org.jetbrains.annotations.NotNull;

public final class AnnotationDeserializer {
    @NotNull
    private final ModuleDescriptor module;
    @NotNull
    private final NotFoundClasses notFoundClasses;

    public AnnotationDeserializer(@NotNull ModuleDescriptor module, @NotNull NotFoundClasses notFoundClasses) {
        Intrinsics.checkNotNullParameter(module, "module");
        Intrinsics.checkNotNullParameter(notFoundClasses, "notFoundClasses");
        this.module = module;
        this.notFoundClasses = notFoundClasses;
    }

    private final KotlinBuiltIns getBuiltIns() {
        return this.module.getBuiltIns();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final AnnotationDescriptor deserializeAnnotation(@NotNull ProtoBuf.Annotation proto, @NotNull NameResolver nameResolver) {
        Intrinsics.checkNotNullParameter(proto, "proto");
        Intrinsics.checkNotNullParameter(nameResolver, "nameResolver");
        ClassDescriptor annotationClass = this.resolveClass(NameResolverUtilKt.getClassId(nameResolver, proto.getId()));
        Map<Name, ConstantValue<Object>> arguments2 = MapsKt.emptyMap();
        if (proto.getArgumentCount() != 0 && !ErrorUtils.isError(annotationClass) && DescriptorUtils.isAnnotationClass(annotationClass)) {
            Collection<ClassConstructorDescriptor> collection = annotationClass.getConstructors();
            Intrinsics.checkNotNullExpressionValue(collection, "annotationClass.constructors");
            ClassConstructorDescriptor constructor = (ClassConstructorDescriptor)CollectionsKt.singleOrNull((Iterable)collection);
            if (constructor != null) {
                void $this$mapNotNullTo$iv$iv;
                void $this$associateByTo$iv$iv;
                List<ValueParameterDescriptor> list = constructor.getValueParameters();
                Intrinsics.checkNotNullExpressionValue(list, "constructor.valueParameters");
                Iterable $this$associateBy$iv = list;
                boolean $i$f$associateBy = false;
                int capacity$iv22 = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
                Iterable iterable = $this$associateBy$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                    void it;
                    ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)element$iv$iv;
                    Map map = destination$iv$iv;
                    boolean bl = false;
                    map.put(it.getName(), element$iv$iv);
                }
                Map parameterByName = destination$iv$iv;
                List<ProtoBuf.Annotation.Argument> list2 = proto.getArgumentList();
                Intrinsics.checkNotNullExpressionValue(list2, "proto.argumentList");
                Iterable $this$mapNotNull$iv = list2;
                boolean $i$f$mapNotNull = false;
                Iterable capacity$iv22 = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Pair<Name, ConstantValue<?>> it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    ProtoBuf.Annotation.Argument it = (ProtoBuf.Annotation.Argument)element$iv$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue(it, "it");
                    if (this.resolveArgument(it, parameterByName, nameResolver) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                arguments2 = MapsKt.toMap((List)destination$iv$iv2);
            }
        }
        return new AnnotationDescriptorImpl(annotationClass.getDefaultType(), arguments2, SourceElement.NO_SOURCE);
    }

    private final Pair<Name, ConstantValue<?>> resolveArgument(ProtoBuf.Annotation.Argument proto, Map<Name, ? extends ValueParameterDescriptor> parameterByName, NameResolver nameResolver) {
        ValueParameterDescriptor valueParameterDescriptor = parameterByName.get(NameResolverUtilKt.getName(nameResolver, proto.getNameId()));
        if (valueParameterDescriptor == null) {
            return null;
        }
        ValueParameterDescriptor parameter = valueParameterDescriptor;
        Name name = NameResolverUtilKt.getName(nameResolver, proto.getNameId());
        KotlinType kotlinType = parameter.getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType, "parameter.type");
        ProtoBuf.Annotation.Argument.Value value2 = proto.getValue();
        Intrinsics.checkNotNullExpressionValue(value2, "proto.value");
        return new Pair(name, this.resolveValueAndCheckExpectedType(kotlinType, value2, nameResolver));
    }

    private final ConstantValue<?> resolveValueAndCheckExpectedType(KotlinType expectedType, ProtoBuf.Annotation.Argument.Value value2, NameResolver nameResolver) {
        ConstantValue constantValue;
        ConstantValue it = constantValue = this.resolveValue(expectedType, value2, nameResolver);
        boolean bl = false;
        ConstantValue constantValue2 = this.doesValueConformToExpectedType(it, expectedType, value2) ? constantValue : null;
        if (constantValue2 == null) {
            constantValue2 = ErrorValue.Companion.create("Unexpected argument value: actual type " + value2.getType() + " != expected type " + expectedType);
        }
        return constantValue2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ConstantValue<?> resolveValue(@NotNull KotlinType expectedType, @NotNull ProtoBuf.Annotation.Argument.Value value2, @NotNull NameResolver nameResolver) {
        ConstantValue constantValue;
        Intrinsics.checkNotNullParameter(expectedType, "expectedType");
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(nameResolver, "nameResolver");
        Boolean bl = Flags.IS_UNSIGNED.get(value2.getFlags());
        Intrinsics.checkNotNullExpressionValue(bl, "IS_UNSIGNED.get(value.flags)");
        boolean isUnsigned = bl;
        ProtoBuf.Annotation.Argument.Value.Type type2 = value2.getType();
        switch (type2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
            case 1: {
                ConstantValue constantValue2;
                AnnotationDeserializer annotationDeserializer = this;
                byte $this$letIf$iv = (byte)value2.getIntValue();
                boolean $i$f$letIf = false;
                if (isUnsigned) {
                    byte p0 = $this$letIf$iv;
                    boolean bl2 = false;
                    constantValue2 = new UByteValue(p0);
                } else {
                    byte p0 = $this$letIf$iv;
                    boolean bl3 = false;
                    constantValue2 = new ByteValue(p0);
                }
                constantValue = constantValue2;
                break;
            }
            case 2: {
                constantValue = new CharValue((char)value2.getIntValue());
                break;
            }
            case 3: {
                ConstantValue constantValue3;
                AnnotationDeserializer this_$iv = this;
                short $this$letIf$iv = (short)value2.getIntValue();
                boolean $i$f$letIf = false;
                if (isUnsigned) {
                    short p0 = $this$letIf$iv;
                    boolean bl4 = false;
                    constantValue3 = new UShortValue(p0);
                } else {
                    short p0 = $this$letIf$iv;
                    boolean bl5 = false;
                    constantValue3 = new ShortValue(p0);
                }
                constantValue = constantValue3;
                break;
            }
            case 4: {
                ConstantValue constantValue4;
                AnnotationDeserializer this_$iv = this;
                int $this$letIf$iv = (int)value2.getIntValue();
                boolean $i$f$letIf = false;
                if (isUnsigned) {
                    int p0 = $this$letIf$iv;
                    boolean bl6 = false;
                    constantValue4 = new UIntValue(p0);
                } else {
                    int p0 = $this$letIf$iv;
                    boolean bl7 = false;
                    constantValue4 = new IntValue(p0);
                }
                constantValue = constantValue4;
                break;
            }
            case 5: {
                ConstantValue constantValue5;
                AnnotationDeserializer this_$iv = this;
                long $this$letIf$iv = value2.getIntValue();
                boolean $i$f$letIf = false;
                if (isUnsigned) {
                    long p0 = $this$letIf$iv;
                    boolean bl8 = false;
                    constantValue5 = new ULongValue(p0);
                } else {
                    long p0 = $this$letIf$iv;
                    boolean bl9 = false;
                    constantValue5 = new LongValue(p0);
                }
                constantValue = constantValue5;
                break;
            }
            case 6: {
                constantValue = new FloatValue(value2.getFloatValue());
                break;
            }
            case 7: {
                constantValue = new DoubleValue(value2.getDoubleValue());
                break;
            }
            case 8: {
                constantValue = new BooleanValue(value2.getIntValue() != 0L);
                break;
            }
            case 9: {
                constantValue = new StringValue(nameResolver.getString(value2.getStringValue()));
                break;
            }
            case 10: {
                constantValue = new KClassValue(NameResolverUtilKt.getClassId(nameResolver, value2.getClassId()), value2.getArrayDimensionCount());
                break;
            }
            case 11: {
                constantValue = new EnumValue(NameResolverUtilKt.getClassId(nameResolver, value2.getClassId()), NameResolverUtilKt.getName(nameResolver, value2.getEnumValueId()));
                break;
            }
            case 12: {
                ProtoBuf.Annotation annotation = value2.getAnnotation();
                Intrinsics.checkNotNullExpressionValue(annotation, "value.annotation");
                constantValue = new AnnotationValue(this.deserializeAnnotation(annotation, nameResolver));
                break;
            }
            case 13: {
                void $this$mapTo$iv$iv;
                List<ProtoBuf.Annotation.Argument.Value> list = value2.getArrayElementList();
                Intrinsics.checkNotNullExpressionValue(list, "value.arrayElementList");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable $i$f$letIf = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ProtoBuf.Annotation.Argument.Value value3 = (ProtoBuf.Annotation.Argument.Value)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl10 = false;
                    SimpleType simpleType2 = this.getBuiltIns().getAnyType();
                    Intrinsics.checkNotNullExpressionValue(simpleType2, "builtIns.anyType");
                    KotlinType kotlinType = simpleType2;
                    Intrinsics.checkNotNullExpressionValue(it, "it");
                    collection.add(this.resolveValue(kotlinType, (ProtoBuf.Annotation.Argument.Value)it, nameResolver));
                }
                KotlinType kotlinType = expectedType;
                List list2 = (List)destination$iv$iv;
                constantValue = new DeserializedArrayValue(list2, kotlinType);
                break;
            }
            default: {
                throw new IllegalStateException(("Unsupported annotation argument type: " + value2.getType() + " (expected " + expectedType + ')').toString());
            }
        }
        return constantValue;
    }

    private final boolean doesValueConformToExpectedType(ConstantValue<?> result2, KotlinType expectedType, ProtoBuf.Annotation.Argument.Value value2) {
        boolean bl;
        ProtoBuf.Annotation.Argument.Value.Type type2 = value2.getType();
        block0 : switch (type2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
            case 10: {
                ClassDescriptor expectedClass;
                ClassifierDescriptor classifierDescriptor = expectedType.getConstructor().getDeclarationDescriptor();
                ClassDescriptor classDescriptor = expectedClass = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
                if (expectedClass == null || KotlinBuiltIns.isKClass(expectedClass)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 13: {
                if (!(result2 instanceof ArrayValue && ((List)((ArrayValue)result2).getValue()).size() == value2.getArrayElementList().size())) {
                    boolean $i$a$-check-AnnotationDeserializer$doesValueConformToExpectedType$22 = false;
                    String $i$a$-check-AnnotationDeserializer$doesValueConformToExpectedType$22 = "Deserialized ArrayValue should have the same number of elements as the original array value: " + result2;
                    throw new IllegalStateException($i$a$-check-AnnotationDeserializer$doesValueConformToExpectedType$22.toString());
                }
                KotlinType kotlinType = this.getBuiltIns().getArrayElementType(expectedType);
                Intrinsics.checkNotNullExpressionValue(kotlinType, "builtIns.getArrayElementType(expectedType)");
                KotlinType expectedElementType = kotlinType;
                Iterable $this$all$iv = CollectionsKt.getIndices((Collection)((ArrayValue)result2).getValue());
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                    break;
                }
                Iterator iterator2 = $this$all$iv.iterator();
                while (iterator2.hasNext()) {
                    int element$iv;
                    int i = element$iv = ((IntIterator)iterator2).nextInt();
                    boolean bl2 = false;
                    ConstantValue constantValue = (ConstantValue)((List)((ArrayValue)result2).getValue()).get(i);
                    ProtoBuf.Annotation.Argument.Value value3 = value2.getArrayElement(i);
                    Intrinsics.checkNotNullExpressionValue(value3, "value.getArrayElement(i)");
                    if (this.doesValueConformToExpectedType(constantValue, expectedElementType, value3)) continue;
                    bl = false;
                    break block0;
                }
                bl = true;
                break;
            }
            default: {
                bl = Intrinsics.areEqual(result2.getType(this.module), expectedType);
            }
        }
        return bl;
    }

    private final ClassDescriptor resolveClass(ClassId classId) {
        return FindClassInModuleKt.findNonGenericClassAcrossDependencies(this.module, classId, this.notFoundClasses);
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProtoBuf.Annotation.Argument.Value.Type.values().length];
            nArray[ProtoBuf.Annotation.Argument.Value.Type.BYTE.ordinal()] = 1;
            nArray[ProtoBuf.Annotation.Argument.Value.Type.CHAR.ordinal()] = 2;
            nArray[ProtoBuf.Annotation.Argument.Value.Type.SHORT.ordinal()] = 3;
            nArray[ProtoBuf.Annotation.Argument.Value.Type.INT.ordinal()] = 4;
            nArray[ProtoBuf.Annotation.Argument.Value.Type.LONG.ordinal()] = 5;
            nArray[ProtoBuf.Annotation.Argument.Value.Type.FLOAT.ordinal()] = 6;
            nArray[ProtoBuf.Annotation.Argument.Value.Type.DOUBLE.ordinal()] = 7;
            nArray[ProtoBuf.Annotation.Argument.Value.Type.BOOLEAN.ordinal()] = 8;
            nArray[ProtoBuf.Annotation.Argument.Value.Type.STRING.ordinal()] = 9;
            nArray[ProtoBuf.Annotation.Argument.Value.Type.CLASS.ordinal()] = 10;
            nArray[ProtoBuf.Annotation.Argument.Value.Type.ENUM.ordinal()] = 11;
            nArray[ProtoBuf.Annotation.Argument.Value.Type.ANNOTATION.ordinal()] = 12;
            nArray[ProtoBuf.Annotation.Argument.Value.Type.ARRAY.ordinal()] = 13;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

