/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data.axml;

public final class NamespaceStack {
    private int[] m_data = new int[32];
    private int m_dataLength;
    private int m_depth;

    public void reset() {
        this.m_dataLength = 0;
        this.m_depth = 0;
    }

    public int getCurrentCount() {
        if (this.m_dataLength == 0) {
            return 0;
        }
        int offset = this.m_dataLength - 1;
        return this.m_data[offset];
    }

    public int getAccumulatedCount(int depth) {
        if (this.m_dataLength == 0 || depth < 0) {
            return 0;
        }
        if (depth > this.m_depth) {
            depth = this.m_depth;
        }
        int accumulatedCount = 0;
        int offset = 0;
        while (depth != 0) {
            int count = this.m_data[offset];
            accumulatedCount += count;
            offset += 2 + count * 2;
            --depth;
        }
        return accumulatedCount;
    }

    public void push(int prefix, int uri) {
        if (this.m_depth == 0) {
            this.increaseDepth();
        }
        this.ensureDataCapacity(2);
        int offset = this.m_dataLength - 1;
        int count = this.m_data[offset];
        this.m_data[offset - 1 - count * 2] = count + 1;
        this.m_data[offset] = prefix;
        this.m_data[offset + 1] = uri;
        this.m_data[offset + 2] = count + 1;
        this.m_dataLength += 2;
    }

    public boolean pop() {
        if (this.m_dataLength == 0) {
            return false;
        }
        int offset = this.m_dataLength - 1;
        int count = this.m_data[offset];
        if (count == 0) {
            return false;
        }
        this.m_data[offset -= 2] = --count;
        this.m_data[offset -= 1 + count * 2] = count;
        this.m_dataLength -= 2;
        return true;
    }

    public int getPrefix(int index) {
        return this.get(index, true);
    }

    public int getUri(int index) {
        return this.get(index, false);
    }

    public int findPrefix(int uri) {
        return this.find(uri, false);
    }

    public int getDepth() {
        return this.m_depth;
    }

    public void increaseDepth() {
        this.ensureDataCapacity(2);
        int offset = this.m_dataLength;
        this.m_data[offset] = 0;
        this.m_data[offset + 1] = 0;
        this.m_dataLength += 2;
        ++this.m_depth;
    }

    public void decreaseDepth() {
        if (this.m_dataLength == 0) {
            return;
        }
        int offset = this.m_dataLength - 1;
        int count = this.m_data[offset];
        if (offset - 1 - count * 2 == 0) {
            return;
        }
        this.m_dataLength -= 2 + count * 2;
        --this.m_depth;
    }

    private void ensureDataCapacity(int capacity) {
        int available = this.m_data.length - this.m_dataLength;
        if (available > capacity) {
            return;
        }
        int newLength = (this.m_data.length + available) * 2;
        int[] newData = new int[newLength];
        System.arraycopy(this.m_data, 0, newData, 0, this.m_dataLength);
        this.m_data = newData;
    }

    private int find(int prefixOrUri, boolean prefix) {
        if (this.m_dataLength == 0) {
            return -1;
        }
        int offset = this.m_dataLength - 1;
        for (int i = this.m_depth; i != 0; --i) {
            int count = this.m_data[offset];
            offset -= 2;
            while (count != 0) {
                if (prefix) {
                    if (this.m_data[offset] == prefixOrUri) {
                        return this.m_data[offset + 1];
                    }
                } else if (this.m_data[offset + 1] == prefixOrUri) {
                    return this.m_data[offset];
                }
                offset -= 2;
                --count;
            }
        }
        return -1;
    }

    private int get(int index, boolean prefix) {
        if (this.m_dataLength == 0 || index < 0) {
            return -1;
        }
        int offset = 0;
        for (int i = this.m_depth; i != 0; --i) {
            int count = this.m_data[offset];
            if (index >= count) {
                index -= count;
                offset += 2 + count * 2;
                continue;
            }
            offset += 1 + index * 2;
            if (!prefix) {
                ++offset;
            }
            return this.m_data[offset];
        }
        return -1;
    }
}

