/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.util.Iterator;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.CharHashMap;
import org.armedbear.lisp.FuncallableStandardObject;
import org.armedbear.lisp.Function;
import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispCharacter;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispReader;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.Operator;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.ReaderError;
import org.armedbear.lisp.Stream;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.WrongNumberOfArgumentsException;

public class Readtable
extends LispObject {
    public static final byte SYNTAX_TYPE_CONSTITUENT = 0;
    public static final byte SYNTAX_TYPE_WHITESPACE = 1;
    public static final byte SYNTAX_TYPE_TERMINATING_MACRO = 2;
    public static final byte SYNTAX_TYPE_NON_TERMINATING_MACRO = 3;
    public static final byte SYNTAX_TYPE_SINGLE_ESCAPE = 4;
    public static final byte SYNTAX_TYPE_MULTIPLE_ESCAPE = 5;
    protected final CharHashMap<Byte> syntax = new CharHashMap<Byte>(Byte.class, (byte)0);
    protected final CharHashMap<LispObject> readerMacroFunctions = new CharHashMap<Object>(LispObject.class, null);
    protected final CharHashMap<DispatchTable> dispatchTables = new CharHashMap<Object>(DispatchTable.class, null);
    protected LispObject readtableCase;
    private static final Primitive READTABLEP = new Primitive("readtablep", "object"){

        @Override
        public LispObject execute(LispObject arg) {
            return arg instanceof Readtable ? Lisp.T : Lisp.NIL;
        }
    };
    private static final Primitive COPY_READTABLE = new Primitive("copy-readtable", "&optional from-readtable to-readtable"){

        @Override
        public LispObject execute() {
            return new Readtable(Lisp.currentReadtable());
        }

        @Override
        public LispObject execute(LispObject arg) {
            return new Readtable(arg);
        }

        @Override
        public LispObject execute(LispObject first, LispObject second) {
            Readtable from = Lisp.designator_readtable(first);
            if (second == Lisp.NIL) {
                return new Readtable(from);
            }
            Readtable to = Lisp.checkReadtable(second);
            Readtable.copyReadtable(from, to);
            return to;
        }
    };
    private static final Primitive GET_MACRO_CHARACTER = new Primitive("get-macro-character", "char &optional readtable"){

        @Override
        public LispObject execute(LispObject arg) {
            char c = LispCharacter.getValue(arg);
            Readtable rt = Lisp.currentReadtable();
            return rt.getMacroCharacter(c);
        }

        @Override
        public LispObject execute(LispObject first, LispObject second) {
            char c = LispCharacter.getValue(first);
            Readtable rt = Lisp.designator_readtable(second);
            return rt.getMacroCharacter(c);
        }
    };
    private static final Primitive SET_MACRO_CHARACTER = new Primitive("set-macro-character", "char new-function &optional non-terminating-p readtable"){

        @Override
        public LispObject execute(LispObject first, LispObject second) {
            return this.execute(first, second, Lisp.NIL, Lisp.currentReadtable());
        }

        @Override
        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            return this.execute(first, second, third, Lisp.currentReadtable());
        }

        @Override
        public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth) {
            LispObject designator;
            char c = LispCharacter.getValue(first);
            if (second instanceof Function || second instanceof FuncallableStandardObject) {
                designator = second;
            } else if (second instanceof Symbol) {
                designator = second;
            } else {
                return Lisp.error(new LispError(second.princToString() + " does not designate a function."));
            }
            byte syntaxType = third != Lisp.NIL ? (byte)3 : 2;
            Readtable rt = Lisp.designator_readtable(fourth);
            rt.syntax.put(c, syntaxType);
            rt.readerMacroFunctions.put(c, designator);
            return Lisp.T;
        }
    };
    private static final Primitive MAKE_DISPATCH_MACRO_CHARACTER = new Primitive("make-dispatch-macro-character", "char &optional non-terminating-p readtable"){

        @Override
        public LispObject execute(LispObject[] args) {
            if (args.length < 1 || args.length > 3) {
                return Lisp.error(new WrongNumberOfArgumentsException((Operator)this, 1, 3));
            }
            char dispChar = LispCharacter.getValue(args[0]);
            LispObject non_terminating_p = args.length > 1 ? args[1] : Lisp.NIL;
            Readtable readtable = args.length == 3 ? Lisp.checkReadtable(args[2]) : Lisp.currentReadtable();
            readtable.makeDispatchMacroCharacter(dispChar, non_terminating_p);
            return Lisp.T;
        }
    };
    private static final Primitive GET_DISPATCH_MACRO_CHARACTER = new Primitive("get-dispatch-macro-character", "disp-char sub-char &optional readtable"){

        @Override
        public LispObject execute(LispObject[] args) {
            if (args.length < 2 || args.length > 3) {
                return Lisp.error(new WrongNumberOfArgumentsException((Operator)this, 1, 3));
            }
            char dispChar = LispCharacter.getValue(args[0]);
            char subChar = LispCharacter.getValue(args[1]);
            Readtable readtable = args.length == 3 ? Lisp.designator_readtable(args[2]) : Lisp.currentReadtable();
            return readtable.getDispatchMacroCharacter(dispChar, subChar);
        }
    };
    private static final Primitive SET_DISPATCH_MACRO_CHARACTER = new Primitive("set-dispatch-macro-character", "disp-char sub-char new-function &optional readtable"){

        @Override
        public LispObject execute(LispObject[] args) {
            if (args.length < 3 || args.length > 4) {
                return Lisp.error(new WrongNumberOfArgumentsException((Operator)this, 3, 4));
            }
            char dispChar = LispCharacter.getValue(args[0]);
            char subChar = LispCharacter.getValue(args[1]);
            LispObject function = Lisp.coerceToFunction(args[2]);
            Readtable readtable = args.length == 4 ? Lisp.designator_readtable(args[3]) : Lisp.currentReadtable();
            readtable.setDispatchMacroCharacter(dispChar, subChar, function);
            return Lisp.T;
        }
    };
    private static final Primitive SET_SYNTAX_FROM_CHAR = new Primitive("set-syntax-from-char", "to-char from-char &optional to-readtable from-readtable"){

        @Override
        public LispObject execute(LispObject[] args) {
            if (args.length < 2 || args.length > 4) {
                return Lisp.error(new WrongNumberOfArgumentsException((Operator)this, 2, 4));
            }
            char toChar = LispCharacter.getValue(args[0]);
            char fromChar = LispCharacter.getValue(args[1]);
            Readtable toReadtable = args.length > 2 ? Lisp.checkReadtable(args[2]) : Lisp.currentReadtable();
            Readtable fromReadtable = args.length > 3 ? Lisp.designator_readtable(args[3]) : Lisp.checkReadtable(Lisp.STANDARD_READTABLE.symbolValue());
            toReadtable.syntax.put(toChar, fromReadtable.syntax.get(fromChar));
            toReadtable.readerMacroFunctions.put(toChar, fromReadtable.readerMacroFunctions.get(fromChar));
            DispatchTable found = fromReadtable.dispatchTables.get(fromChar);
            if (found != null) {
                toReadtable.dispatchTables.put(toChar, new DispatchTable(found));
            } else {
                toReadtable.dispatchTables.put(toChar, null);
            }
            return Lisp.T;
        }
    };
    private static final Primitive READTABLE_CASE = new Primitive("readtable-case", "readtable"){

        @Override
        public LispObject execute(LispObject arg) {
            return Lisp.checkReadtable((LispObject)arg).readtableCase;
        }
    };
    private static final Primitive _SET_READTABLE_CASE = new Primitive("%set-readtable-case", Lisp.PACKAGE_SYS, false, "readtable new-mode"){

        @Override
        public LispObject execute(LispObject first, LispObject second) {
            Readtable readtable = Lisp.checkReadtable(first);
            if (second == Keyword.UPCASE || second == Keyword.DOWNCASE || second == Keyword.INVERT || second == Keyword.PRESERVE) {
                readtable.readtableCase = second;
                return second;
            }
            return Lisp.type_error(second, Lisp.list(Symbol.MEMBER, Keyword.INVERT, Keyword.PRESERVE, Keyword.DOWNCASE, Keyword.UPCASE));
        }
    };

    public Readtable() {
        this.initialize();
    }

    protected void initialize() {
        Byte[] syntax = (Byte[])this.syntax.constants;
        syntax[9] = 1;
        syntax[10] = 1;
        syntax[12] = 1;
        syntax[13] = 1;
        syntax[32] = 1;
        syntax[34] = 2;
        syntax[39] = 2;
        syntax[40] = 2;
        syntax[41] = 2;
        syntax[44] = 2;
        syntax[59] = 2;
        syntax[96] = 2;
        syntax[35] = 3;
        syntax[92] = 4;
        syntax[124] = 5;
        LispObject[] readerMacroFunctions = (LispObject[])this.readerMacroFunctions.constants;
        readerMacroFunctions[59] = LispReader.READ_COMMENT;
        readerMacroFunctions[34] = LispReader.READ_STRING;
        readerMacroFunctions[40] = LispReader.READ_LIST;
        readerMacroFunctions[41] = LispReader.READ_RIGHT_PAREN;
        readerMacroFunctions[39] = LispReader.READ_QUOTE;
        readerMacroFunctions[35] = LispReader.READ_DISPATCH_CHAR;
        readerMacroFunctions[96] = Symbol.BACKQUOTE_MACRO;
        readerMacroFunctions[44] = Symbol.COMMA_MACRO;
        DispatchTable dt = new DispatchTable();
        LispObject[] dtfunctions = (LispObject[])dt.functions.constants;
        dtfunctions[40] = LispReader.SHARP_LEFT_PAREN;
        dtfunctions[42] = LispReader.SHARP_STAR;
        dtfunctions[46] = LispReader.SHARP_DOT;
        dtfunctions[58] = LispReader.SHARP_COLON;
        dtfunctions[65] = LispReader.SHARP_A;
        dtfunctions[66] = LispReader.SHARP_B;
        dtfunctions[67] = LispReader.SHARP_C;
        dtfunctions[79] = LispReader.SHARP_O;
        dtfunctions[80] = LispReader.SHARP_P;
        dtfunctions[82] = LispReader.SHARP_R;
        dtfunctions[83] = LispReader.SHARP_S;
        dtfunctions[88] = LispReader.SHARP_X;
        dtfunctions[39] = LispReader.SHARP_QUOTE;
        dtfunctions[92] = LispReader.SHARP_BACKSLASH;
        dtfunctions[124] = LispReader.SHARP_VERTICAL_BAR;
        dtfunctions[41] = LispReader.SHARP_ILLEGAL;
        dtfunctions[60] = LispReader.SHARP_ILLEGAL;
        dtfunctions[32] = LispReader.SHARP_ILLEGAL;
        dtfunctions[8] = LispReader.SHARP_ILLEGAL;
        dtfunctions[9] = LispReader.SHARP_ILLEGAL;
        dtfunctions[10] = LispReader.SHARP_ILLEGAL;
        dtfunctions[12] = LispReader.SHARP_ILLEGAL;
        dtfunctions[13] = LispReader.SHARP_ILLEGAL;
        ((DispatchTable[])this.dispatchTables.constants)[35] = dt;
        this.readtableCase = Keyword.UPCASE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Readtable(LispObject obj) {
        Readtable rt = obj == Lisp.NIL ? Lisp.checkReadtable(Lisp.STANDARD_READTABLE.symbolValue()) : Lisp.checkReadtable(obj);
        Readtable readtable = rt;
        synchronized (readtable) {
            Readtable.copyReadtable(rt, this);
        }
    }

    static void copyReadtable(Readtable from, Readtable to) {
        Object dt;
        char c;
        Iterator<Character> charIterator = from.syntax.getCharIterator();
        while (charIterator.hasNext()) {
            c = charIterator.next().charValue();
            dt = from.syntax.get(c);
            if (dt != null) {
                to.syntax.put(c, (Byte)dt);
                continue;
            }
            to.syntax.put(c, null);
        }
        charIterator = from.readerMacroFunctions.getCharIterator();
        while (charIterator.hasNext()) {
            c = charIterator.next().charValue();
            dt = from.readerMacroFunctions.get(c);
            if (dt != null) {
                to.readerMacroFunctions.put(c, (LispObject)dt);
                continue;
            }
            to.readerMacroFunctions.put(c, null);
        }
        charIterator = from.dispatchTables.getCharIterator();
        while (charIterator.hasNext()) {
            c = charIterator.next().charValue();
            dt = from.dispatchTables.get(c);
            if (dt != null) {
                to.dispatchTables.put(c, new DispatchTable((DispatchTable)dt));
                continue;
            }
            to.dispatchTables.put(c, null);
        }
        to.readtableCase = from.readtableCase;
    }

    @Override
    public final LispObject typeOf() {
        return Symbol.READTABLE;
    }

    @Override
    public final LispObject classOf() {
        return BuiltInClass.READTABLE;
    }

    @Override
    public final LispObject typep(LispObject type) {
        if (type == Symbol.READTABLE) {
            return Lisp.T;
        }
        if (type == BuiltInClass.READTABLE) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    public final LispObject getReadtableCase() {
        return this.readtableCase;
    }

    public final boolean isWhitespace(char c) {
        return this.getSyntaxType(c) == 1;
    }

    public final byte getSyntaxType(char c) {
        return this.syntax.get(c);
    }

    public final boolean isInvalid(char c) {
        switch (c) {
            case '\b': 
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': 
            case '\u007f': {
                return true;
            }
        }
        return false;
    }

    public final void checkInvalid(char c, Stream stream) {
        if (this.isInvalid(c)) {
            String name = LispCharacter.charToName(c);
            StringBuilder sb = new StringBuilder("Invalid character");
            if (name != null) {
                sb.append(" #\\");
                sb.append(name);
            }
            Lisp.error(new ReaderError(sb.toString(), stream));
        }
    }

    public final LispObject getReaderMacroFunction(char c) {
        return this.readerMacroFunctions.get(c);
    }

    final LispObject getMacroCharacter(char c) {
        Symbol non_terminating_p;
        LispObject function = this.getReaderMacroFunction(c);
        if (function != null) {
            non_terminating_p = this.syntax.get(c) == 3 ? Lisp.T : Lisp.NIL;
        } else {
            function = Lisp.NIL;
            non_terminating_p = Lisp.NIL;
        }
        return LispThread.currentThread().setValues(function, non_terminating_p);
    }

    final void makeDispatchMacroCharacter(char dispChar, LispObject non_terminating_p) {
        byte syntaxType = non_terminating_p != Lisp.NIL ? (byte)3 : 2;
        this.syntax.put(dispChar, syntaxType);
        this.readerMacroFunctions.put(dispChar, LispReader.READ_DISPATCH_CHAR);
        this.dispatchTables.put(dispChar, new DispatchTable());
    }

    public final LispObject getDispatchMacroCharacter(char dispChar, char subChar) {
        DispatchTable dispatchTable = this.dispatchTables.get(dispChar);
        if (dispatchTable == null) {
            LispCharacter c = LispCharacter.getInstance(dispChar);
            return Lisp.error(new LispError(c.princToString() + " is not a dispatch character."));
        }
        LispObject function = dispatchTable.functions.get(LispCharacter.toUpperCase(subChar));
        return function != null ? function : Lisp.NIL;
    }

    public final void setDispatchMacroCharacter(char dispChar, char subChar, LispObject function) {
        DispatchTable dispatchTable = this.dispatchTables.get(dispChar);
        if (dispatchTable == null) {
            LispCharacter c = LispCharacter.getInstance(dispChar);
            Lisp.error(new LispError(c.princToString() + " is not a dispatch character."));
        }
        dispatchTable.functions.put(LispCharacter.toUpperCase(subChar), function);
    }

    protected static class DispatchTable {
        protected final CharHashMap<LispObject> functions;

        public DispatchTable() {
            this.functions = new CharHashMap<Object>(LispObject.class, null);
        }

        public DispatchTable(DispatchTable dt) {
            this.functions = (CharHashMap)dt.functions.clone();
        }
    }
}

