/*
 * Decompiled with CFR 0.152.
 */
package javolution.text;

import java.io.IOException;
import java.text.ParsePosition;
import javolution.context.ObjectFactory;
import javolution.text.CharSet;
import javolution.text.Text;
import javolution.text.TextBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TextFormat<T> {
    protected TextFormat() {
    }

    public abstract Appendable format(T var1, Appendable var2) throws IOException;

    public abstract T parse(CharSequence var1, Cursor var2);

    public final Text format(T t) {
        try {
            TextBuilder textBuilder = TextBuilder.newInstance();
            this.format(t, textBuilder);
            return textBuilder.toText();
        }
        catch (IOException iOException) {
            throw new Error();
        }
    }

    public final T parse(CharSequence charSequence) {
        Cursor cursor = Cursor.newInstance();
        try {
            T t = this.parse(charSequence, cursor);
            if (cursor.getIndex() != charSequence.length()) {
                throw new IllegalArgumentException("Parsing of " + charSequence + " incomplete (terminated at index: " + cursor.getIndex() + ")");
            }
            T t2 = t;
            return t2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalArgumentException("Cannot parse \"" + charSequence + "\" (" + runtimeException.toString() + ")");
        }
        finally {
            cursor.recycle();
        }
    }

    public static class Cursor
    extends ParsePosition {
        private static final ObjectFactory FACTORY = new ObjectFactory(){

            public Object create() {
                return new Cursor();
            }
        };
        private int _index;

        Cursor() {
            super(0);
        }

        public static Cursor newInstance() {
            Cursor cursor = (Cursor)FACTORY.object();
            cursor._index = 0;
            return cursor;
        }

        public final int getIndex() {
            return this._index;
        }

        public final void setIndex(int n) {
            this._index = n;
        }

        public final boolean hasNext(CharSequence charSequence) {
            return this._index < charSequence.length();
        }

        public final char next(CharSequence charSequence) {
            return charSequence.charAt(this._index++);
        }

        public final boolean skip(char c, CharSequence charSequence) {
            int n = charSequence.length();
            while (this._index < n && charSequence.charAt(this._index) == c) {
                ++this._index;
            }
            return this._index < n;
        }

        public final boolean skip(CharSet charSet, CharSequence charSequence) {
            int n = charSequence.length();
            while (this._index < n && charSet.contains(charSequence.charAt(this._index))) {
                ++this._index;
            }
            return this._index < n;
        }

        public final void increment() {
            ++this._index;
        }

        public final void increment(int n) {
            this._index += n;
        }

        public final void recycle() {
            FACTORY.recycle(this);
        }

        public String toString() {
            return String.valueOf(this._index);
        }
    }
}

