module Test_grubenv =

  let conf = "# GRUB Environment Block
serial=1
serial_speed=115200
dummy1=abc\\\\xyz
dummy2=abc\\
xyz
dummy3=abc\\\\uvw\\
xyz
########################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################
"

  test GrubEnv.lns get conf =
  { "#comment" = "GRUB Environment Block" }
  { "1"
    { "name" = "serial" }
    { "value" = "1" }
  }
  { "2"
    { "name" = "serial_speed" }
    { "value" = "115200" }
  }
  { "3"
    { "name" = "dummy1" }
    { "value" = "abc\\\\xyz" }
  }
  { "4"
    { "name" = "dummy2" }
    { "value" = "abc\\\nxyz" }
  }
  { "5"
    { "name" = "dummy3" }
    { "value" = "abc\\\\uvw\\\nxyz" }
  }
  { "#comment" = "#######################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################################" }
