/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.util.FileUtils;

public class BuildNumber
extends Task {
    private static final String DEFAULT_PROPERTY_NAME = "build.number";
    private static final String DEFAULT_FILENAME = "build.number";
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private File myFile;

    public void setFile(File file) {
        this.myFile = file;
    }

    /*
     * Loose catch block
     */
    public void execute() throws BuildException {
        int buildNumber;
        File savedFile;
        block8: {
            savedFile = this.myFile;
            this.validate();
            Properties properties = this.loadProperties();
            buildNumber = this.getBuildNumber(properties);
            properties.put("build.number", String.valueOf(buildNumber + 1));
            FileOutputStream output = null;
            output = new FileOutputStream(this.myFile);
            String header = "Build Number for ANT. Do not edit!";
            properties.store(output, "Build Number for ANT. Do not edit!");
            Object var8_7 = null;
            if (null == output) break block8;
            try {
                output.close();
                break block8;
            }
            catch (IOException ioe) {
                this.log("error closing output stream " + ioe, 0);
            }
            {
                break block8;
                catch (IOException ioe) {
                    String message = "Error while writing " + this.myFile;
                    throw new BuildException(message, ioe);
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (null != output) {
                    try {
                        output.close();
                    }
                    catch (IOException ioe) {
                        this.log("error closing output stream " + ioe, 0);
                    }
                }
                this.myFile = savedFile;
                throw throwable;
            }
        }
        this.myFile = savedFile;
        this.getProject().setNewProperty("build.number", String.valueOf(buildNumber));
    }

    private int getBuildNumber(Properties properties) throws BuildException {
        String buildNumber = properties.getProperty("build.number", "0").trim();
        try {
            return Integer.parseInt(buildNumber);
        }
        catch (NumberFormatException nfe) {
            String message = this.myFile + " contains a non integer build number: " + buildNumber;
            throw new BuildException(message, nfe);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties loadProperties() throws BuildException {
        Properties properties;
        FileInputStream input = null;
        try {
            try {
                Properties properties2 = new Properties();
                input = new FileInputStream(this.myFile);
                properties2.load(input);
                properties = properties2;
                Object var5_5 = null;
                if (null == input) return properties;
            }
            catch (IOException ioe) {
                throw new BuildException(ioe);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (null == input) throw throwable;
            try {
                input.close();
                throw throwable;
            }
            catch (IOException ioe2) {
                this.log("error closing input stream " + ioe2, 0);
                throw throwable;
            }
        }
        try {}
        catch (IOException ioe2) {
            this.log("error closing input stream " + ioe2, 0);
            return properties;
        }
        input.close();
        return properties;
    }

    private void validate() throws BuildException {
        if (null == this.myFile) {
            this.myFile = FILE_UTILS.resolveFile(this.getProject().getBaseDir(), "build.number");
        }
        if (!this.myFile.exists()) {
            try {
                FILE_UTILS.createNewFile(this.myFile);
            }
            catch (IOException ioe) {
                String message = this.myFile + " doesn't exist and new file can't be created.";
                throw new BuildException(message, ioe);
            }
        }
        if (!this.myFile.canRead()) {
            String message = "Unable to read from " + this.myFile + ".";
            throw new BuildException(message);
        }
        if (!this.myFile.canWrite()) {
            String message = "Unable to write to " + this.myFile + ".";
            throw new BuildException(message);
        }
    }
}

