/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.dxf.reader;

import de.escape.quincunx.dxf.reader.DxfConverter;
import de.escape.quincunx.dxf.reader.DxfEntity;
import de.escape.quincunx.dxf.reader.DxfFile;
import de.escape.quincunx.trafo.Point3D;

public class DxfSOLID
extends DxfEntity {
    protected Point3D[] corner = new Point3D[4];
    protected short maxPointUsed = (short)-1;

    public DxfSOLID() {
        this.corner[0] = new Point3D();
        this.corner[1] = new Point3D();
        this.corner[2] = new Point3D();
        this.corner[3] = new Point3D();
    }

    public boolean setGroup(short grpNr, float fval) {
        switch (grpNr) {
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                this.setCoord(this.corner[grpNr % 10], grpNr / 10, fval);
                if (grpNr % 10 > this.maxPointUsed) {
                    this.maxPointUsed = (short)(grpNr % 10);
                }
                return true;
            }
        }
        return super.setGroup(grpNr, fval);
    }

    public boolean setGroup(short grpNr, int ival) {
        return super.setGroup(grpNr, ival);
    }

    protected void preConvert() {
        if (this.maxPointUsed < 3 && this.maxPointUsed > 0) {
            int p = this.maxPointUsed + 1;
            while (p < this.corner.length) {
                this.corner[p] = this.corner[this.maxPointUsed];
                ++p;
            }
            this.maxPointUsed = (short)3;
        }
    }

    public void convert(DxfConverter converter, DxfFile dxf, Object collector) {
        this.preConvert();
        converter.convert(this, dxf, collector);
    }

    public final Point3D[] getCorners() {
        return this.corner;
    }
}

