/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrCompositionLayerBaseHeader;
import org.lwjgl.openxr.XrQuaternionf;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.openxr.XrSwapchain;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrCompositionLayerCubeKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int LAYERFLAGS;
    public static final int SPACE;
    public static final int EYEVISIBILITY;
    public static final int SWAPCHAIN;
    public static final int IMAGEARRAYINDEX;
    public static final int ORIENTATION;

    public XrCompositionLayerCubeKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrCompositionLayerCubeKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrCompositionLayerCubeKHR.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrCompositionLayerCubeKHR.nnext(this.address());
    }

    @NativeType(value="XrCompositionLayerFlags")
    public long layerFlags() {
        return XrCompositionLayerCubeKHR.nlayerFlags(this.address());
    }

    @NativeType(value="XrSpace")
    public long space() {
        return XrCompositionLayerCubeKHR.nspace(this.address());
    }

    @NativeType(value="XrEyeVisibility")
    public int eyeVisibility() {
        return XrCompositionLayerCubeKHR.neyeVisibility(this.address());
    }

    @NativeType(value="XrSwapchain")
    public long swapchain() {
        return XrCompositionLayerCubeKHR.nswapchain(this.address());
    }

    @NativeType(value="uint32_t")
    public int imageArrayIndex() {
        return XrCompositionLayerCubeKHR.nimageArrayIndex(this.address());
    }

    public XrQuaternionf orientation() {
        return XrCompositionLayerCubeKHR.norientation(this.address());
    }

    public XrCompositionLayerCubeKHR type(@NativeType(value="XrStructureType") int value) {
        XrCompositionLayerCubeKHR.ntype(this.address(), value);
        return this;
    }

    public XrCompositionLayerCubeKHR type$Default() {
        return this.type(1000006000);
    }

    public XrCompositionLayerCubeKHR next(@NativeType(value="void const *") long value) {
        XrCompositionLayerCubeKHR.nnext(this.address(), value);
        return this;
    }

    public XrCompositionLayerCubeKHR layerFlags(@NativeType(value="XrCompositionLayerFlags") long value) {
        XrCompositionLayerCubeKHR.nlayerFlags(this.address(), value);
        return this;
    }

    public XrCompositionLayerCubeKHR space(XrSpace value) {
        XrCompositionLayerCubeKHR.nspace(this.address(), value);
        return this;
    }

    public XrCompositionLayerCubeKHR eyeVisibility(@NativeType(value="XrEyeVisibility") int value) {
        XrCompositionLayerCubeKHR.neyeVisibility(this.address(), value);
        return this;
    }

    public XrCompositionLayerCubeKHR swapchain(XrSwapchain value) {
        XrCompositionLayerCubeKHR.nswapchain(this.address(), value);
        return this;
    }

    public XrCompositionLayerCubeKHR imageArrayIndex(@NativeType(value="uint32_t") int value) {
        XrCompositionLayerCubeKHR.nimageArrayIndex(this.address(), value);
        return this;
    }

    public XrCompositionLayerCubeKHR orientation(XrQuaternionf value) {
        XrCompositionLayerCubeKHR.norientation(this.address(), value);
        return this;
    }

    public XrCompositionLayerCubeKHR orientation(Consumer<XrQuaternionf> consumer) {
        consumer.accept(this.orientation());
        return this;
    }

    public XrCompositionLayerCubeKHR set(int type, long next, long layerFlags, XrSpace space, int eyeVisibility, XrSwapchain swapchain, int imageArrayIndex, XrQuaternionf orientation) {
        this.type(type);
        this.next(next);
        this.layerFlags(layerFlags);
        this.space(space);
        this.eyeVisibility(eyeVisibility);
        this.swapchain(swapchain);
        this.imageArrayIndex(imageArrayIndex);
        this.orientation(orientation);
        return this;
    }

    public XrCompositionLayerCubeKHR set(XrCompositionLayerCubeKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrCompositionLayerCubeKHR malloc() {
        return (XrCompositionLayerCubeKHR)XrCompositionLayerCubeKHR.wrap(XrCompositionLayerCubeKHR.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrCompositionLayerCubeKHR calloc() {
        return (XrCompositionLayerCubeKHR)XrCompositionLayerCubeKHR.wrap(XrCompositionLayerCubeKHR.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrCompositionLayerCubeKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrCompositionLayerCubeKHR)XrCompositionLayerCubeKHR.wrap(XrCompositionLayerCubeKHR.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrCompositionLayerCubeKHR create(long address) {
        return (XrCompositionLayerCubeKHR)XrCompositionLayerCubeKHR.wrap(XrCompositionLayerCubeKHR.class, (long)address);
    }

    @Nullable
    public static XrCompositionLayerCubeKHR createSafe(long address) {
        return address == 0L ? null : (XrCompositionLayerCubeKHR)XrCompositionLayerCubeKHR.wrap(XrCompositionLayerCubeKHR.class, (long)address);
    }

    public static XrCompositionLayerCubeKHR create(XrCompositionLayerBaseHeader value) {
        return (XrCompositionLayerCubeKHR)XrCompositionLayerCubeKHR.wrap(XrCompositionLayerCubeKHR.class, (Struct)value);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrCompositionLayerCubeKHR.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrCompositionLayerCubeKHR.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrCompositionLayerCubeKHR.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrCompositionLayerCubeKHR.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrCompositionLayerCubeKHR.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrCompositionLayerCubeKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrCompositionLayerCubeKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static Buffer create(XrCompositionLayerBaseHeader.Buffer value) {
        return (Buffer)XrCompositionLayerCubeKHR.wrap(Buffer.class, (CustomBuffer)value);
    }

    public static XrCompositionLayerCubeKHR malloc(MemoryStack stack) {
        return (XrCompositionLayerCubeKHR)XrCompositionLayerCubeKHR.wrap(XrCompositionLayerCubeKHR.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrCompositionLayerCubeKHR calloc(MemoryStack stack) {
        return (XrCompositionLayerCubeKHR)XrCompositionLayerCubeKHR.wrap(XrCompositionLayerCubeKHR.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrCompositionLayerCubeKHR.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrCompositionLayerCubeKHR.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long nlayerFlags(long struct) {
        return UNSAFE.getLong(null, struct + (long)LAYERFLAGS);
    }

    public static long nspace(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SPACE));
    }

    public static int neyeVisibility(long struct) {
        return UNSAFE.getInt(null, struct + (long)EYEVISIBILITY);
    }

    public static long nswapchain(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SWAPCHAIN));
    }

    public static int nimageArrayIndex(long struct) {
        return UNSAFE.getInt(null, struct + (long)IMAGEARRAYINDEX);
    }

    public static XrQuaternionf norientation(long struct) {
        return XrQuaternionf.create(struct + (long)ORIENTATION);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nlayerFlags(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)LAYERFLAGS, value);
    }

    public static void nspace(long struct, XrSpace value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SPACE), (long)value.address());
    }

    public static void neyeVisibility(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)EYEVISIBILITY, value);
    }

    public static void nswapchain(long struct, XrSwapchain value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SWAPCHAIN), (long)value.address());
    }

    public static void nimageArrayIndex(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)IMAGEARRAYINDEX, value);
    }

    public static void norientation(long struct, XrQuaternionf value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)ORIENTATION), (long)XrQuaternionf.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)SPACE)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)SWAPCHAIN)));
    }

    static {
        Struct.Layout layout = XrCompositionLayerCubeKHR.__struct((Struct.Member[])new Struct.Member[]{XrCompositionLayerCubeKHR.__member((int)4), XrCompositionLayerCubeKHR.__member((int)POINTER_SIZE), XrCompositionLayerCubeKHR.__member((int)8), XrCompositionLayerCubeKHR.__member((int)POINTER_SIZE), XrCompositionLayerCubeKHR.__member((int)4), XrCompositionLayerCubeKHR.__member((int)POINTER_SIZE), XrCompositionLayerCubeKHR.__member((int)4), XrCompositionLayerCubeKHR.__member((int)XrQuaternionf.SIZEOF, (int)XrQuaternionf.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        LAYERFLAGS = layout.offsetof(2);
        SPACE = layout.offsetof(3);
        EYEVISIBILITY = layout.offsetof(4);
        SWAPCHAIN = layout.offsetof(5);
        IMAGEARRAYINDEX = layout.offsetof(6);
        ORIENTATION = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<XrCompositionLayerCubeKHR, Buffer>
    implements NativeResource {
        private static final XrCompositionLayerCubeKHR ELEMENT_FACTORY = XrCompositionLayerCubeKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrCompositionLayerCubeKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrCompositionLayerCubeKHR.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrCompositionLayerCubeKHR.nnext(this.address());
        }

        @NativeType(value="XrCompositionLayerFlags")
        public long layerFlags() {
            return XrCompositionLayerCubeKHR.nlayerFlags(this.address());
        }

        @NativeType(value="XrSpace")
        public long space() {
            return XrCompositionLayerCubeKHR.nspace(this.address());
        }

        @NativeType(value="XrEyeVisibility")
        public int eyeVisibility() {
            return XrCompositionLayerCubeKHR.neyeVisibility(this.address());
        }

        @NativeType(value="XrSwapchain")
        public long swapchain() {
            return XrCompositionLayerCubeKHR.nswapchain(this.address());
        }

        @NativeType(value="uint32_t")
        public int imageArrayIndex() {
            return XrCompositionLayerCubeKHR.nimageArrayIndex(this.address());
        }

        public XrQuaternionf orientation() {
            return XrCompositionLayerCubeKHR.norientation(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrCompositionLayerCubeKHR.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000006000);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrCompositionLayerCubeKHR.nnext(this.address(), value);
            return this;
        }

        public Buffer layerFlags(@NativeType(value="XrCompositionLayerFlags") long value) {
            XrCompositionLayerCubeKHR.nlayerFlags(this.address(), value);
            return this;
        }

        public Buffer space(XrSpace value) {
            XrCompositionLayerCubeKHR.nspace(this.address(), value);
            return this;
        }

        public Buffer eyeVisibility(@NativeType(value="XrEyeVisibility") int value) {
            XrCompositionLayerCubeKHR.neyeVisibility(this.address(), value);
            return this;
        }

        public Buffer swapchain(XrSwapchain value) {
            XrCompositionLayerCubeKHR.nswapchain(this.address(), value);
            return this;
        }

        public Buffer imageArrayIndex(@NativeType(value="uint32_t") int value) {
            XrCompositionLayerCubeKHR.nimageArrayIndex(this.address(), value);
            return this;
        }

        public Buffer orientation(XrQuaternionf value) {
            XrCompositionLayerCubeKHR.norientation(this.address(), value);
            return this;
        }

        public Buffer orientation(Consumer<XrQuaternionf> consumer) {
            consumer.accept(this.orientation());
            return this;
        }
    }
}

