/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client.exemplars;

import java.util.Arrays;
import java.util.Map;
import java.util.regex.Pattern;

public class Exemplar {
    private final String[] labels;
    private final double value;
    private final Long timestampMs;
    private static final Pattern labelNameRegex = Pattern.compile("[a-zA-Z_][a-zA-Z_0-9]*");

    public Exemplar(double value2, String ... labels) {
        this(value2, (Long)null, labels);
    }

    public Exemplar(double value2, Long timestampMs, String ... labels) {
        this.labels = this.sortedCopy(labels);
        this.value = value2;
        this.timestampMs = timestampMs;
    }

    public Exemplar(double value2, Map<String, String> labels) {
        this(value2, (Long)null, Exemplar.mapToArray(labels));
    }

    public Exemplar(double value2, Long timestampMs, Map<String, String> labels) {
        this(value2, timestampMs, Exemplar.mapToArray(labels));
    }

    public int getNumberOfLabels() {
        return this.labels.length / 2;
    }

    public String getLabelName(int i) {
        return this.labels[2 * i];
    }

    public String getLabelValue(int i) {
        return this.labels[2 * i + 1];
    }

    public double getValue() {
        return this.value;
    }

    public Long getTimestampMs() {
        return this.timestampMs;
    }

    private String[] sortedCopy(String ... labels) {
        if (labels.length % 2 != 0) {
            throw new IllegalArgumentException("labels are name/value pairs, expecting an even number");
        }
        String[] result2 = new String[labels.length];
        int charsTotal = 0;
        block0: for (int i = 0; i < labels.length; i += 2) {
            if (labels[i] == null) {
                throw new IllegalArgumentException("labels[" + i + "] is null");
            }
            if (labels[i + 1] == null) {
                throw new IllegalArgumentException("labels[" + (i + 1) + "] is null");
            }
            if (!labelNameRegex.matcher(labels[i]).matches()) {
                throw new IllegalArgumentException(labels[i] + " is not a valid label name");
            }
            result2[i] = labels[i];
            result2[i + 1] = labels[i + 1];
            charsTotal += labels[i].length() + labels[i + 1].length();
            for (int j = i - 2; j >= 0; j -= 2) {
                int compareResult = result2[j + 2].compareTo(result2[j]);
                if (compareResult == 0) {
                    throw new IllegalArgumentException(result2[j] + ": label name is not unique");
                }
                if (compareResult >= 0) continue block0;
                String tmp = result2[j];
                result2[j] = result2[j + 2];
                result2[j + 2] = tmp;
                tmp = result2[j + 1];
                result2[j + 1] = result2[j + 3];
                result2[j + 3] = tmp;
            }
        }
        if (charsTotal > 128) {
            throw new IllegalArgumentException("the combined length of the label names and values must not exceed 128 UTF-8 characters");
        }
        return result2;
    }

    public static String[] mapToArray(Map<String, String> labelMap) {
        if (labelMap == null) {
            return null;
        }
        String[] result2 = new String[2 * labelMap.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : labelMap.entrySet()) {
            result2[i] = entry.getKey();
            result2[i + 1] = entry.getValue();
            i += 2;
        }
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Exemplar)) {
            return false;
        }
        Exemplar other = (Exemplar)obj;
        return Arrays.equals(this.labels, other.labels) && Double.compare(other.value, this.value) == 0 && (this.timestampMs == null && other.timestampMs == null || this.timestampMs != null && this.timestampMs.equals(other.timestampMs));
    }

    public int hashCode() {
        int hash = Arrays.hashCode(this.labels);
        long d = Double.doubleToLongBits(this.value);
        hash = 37 * hash + (int)(d ^ d >>> 32);
        if (this.timestampMs != null) {
            hash = 37 * hash + this.timestampMs.intValue();
        }
        return hash;
    }
}

